/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.rule;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.Relation;
import ai.grakn.graql.internal.reasoner.atom.binary.Resource;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class InferenceRule {
    private final ConceptId ruleId;
    private final ReasonerQueryImpl body;
    private final ReasonerAtomicQuery head;
    private int priority = Integer.MAX_VALUE;

    public InferenceRule(Rule rule, GraknGraph graph) {
        this.ruleId = rule.getId();
        this.body = ReasonerQueries.create(InferenceRule.conjunction(rule.getLHS().admin()), graph);
        this.head = ReasonerQueries.atomic(InferenceRule.conjunction(rule.getRHS().admin()), graph);
        if (!this.getHead().getAtom().isAllowedToFormRuleHead()) {
            throw new IllegalArgumentException(ErrorMessage.DISALLOWED_ATOM_IN_RULE_HEAD.getMessage(new Object[]{this.getHead().getAtom(), this.toString()}));
        }
    }

    public InferenceRule(InferenceRule r) {
        this.ruleId = r.getRuleId();
        this.body = ReasonerQueries.create(r.getBody());
        this.head = ReasonerQueries.atomic(r.getHead());
    }

    public String toString() {
        return "\n" + this.body.toString() + "->" + this.head.toString() + "[" + this.resolutionPriority() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InferenceRule rule = (InferenceRule)obj;
        return this.getBody().equals(rule.getBody()) && this.getHead().equals(rule.getHead());
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.getBody().hashCode();
        hashCode = hashCode * 37 + this.getHead().hashCode();
        return hashCode;
    }

    public int resolutionPriority() {
        if (this.priority == Integer.MAX_VALUE) {
            this.priority = this.getBody().resolutionPriority();
        }
        return this.priority;
    }

    private static Conjunction<VarPatternAdmin> conjunction(PatternAdmin pattern) {
        Set vars = pattern.getDisjunctiveNormalForm().getPatterns().stream().flatMap(p -> p.getPatterns().stream()).collect(Collectors.toSet());
        return Patterns.conjunction(vars);
    }

    public ConceptId getRuleId() {
        return this.ruleId;
    }

    public boolean hasDisconnectedHead() {
        return Sets.intersection(this.body.getVarNames(), this.head.getVarNames()).isEmpty();
    }

    public boolean requiresMaterialisation(Atom parentAtom) {
        return parentAtom.requiresMaterialisation() || this.getHead().getAtom().requiresMaterialisation() || this.hasDisconnectedHead();
    }

    public ReasonerQueryImpl getBody() {
        return this.body;
    }

    public ReasonerAtomicQuery getHead() {
        return this.head;
    }

    public Atom getRuleConclusionAtom() {
        ReasonerAtomicQuery ruleQuery = ReasonerQueries.atomic(this.head);
        Atom atom = ruleQuery.getAtom();
        this.body.getAtoms().forEach(at -> ruleQuery.addAtomic(at.copy()));
        return atom;
    }

    public InferenceRule propagateConstraints(Atom parentAtom, Unifier ruleUnifier, Unifier permutationUnifier) {
        if (!parentAtom.isRelation() && !parentAtom.isResource()) {
            return this;
        }
        Atom headAtom = this.head.getAtom();
        if (headAtom.isResource() && ((Resource)headAtom).getMultiPredicate().isEmpty()) {
            Set valuePredicates = parentAtom.getValuePredicates().stream().map(ValuePredicate::copy).map(type -> type.unify(permutationUnifier)).map(type -> type.unify(ruleUnifier)).map(type -> (ValuePredicate)type).collect(Collectors.toSet());
            this.head.addAtomConstraints(valuePredicates);
            this.body.addAtomConstraints(valuePredicates);
        }
        Set unifiedTypes = parentAtom.getTypeConstraints().stream().map(TypeAtom::copy).map(type -> type.unify(permutationUnifier)).map(type -> type.unify(ruleUnifier)).map(type -> (TypeAtom)type).collect(Collectors.toSet());
        Set<TypeAtom> ruleTypes = this.body.getTypeConstraints().stream().filter(t -> !t.isRelation()).collect(Collectors.toSet());
        Sets.SetView allTypes = Sets.union(unifiedTypes, ruleTypes);
        Set types = allTypes.stream().filter(arg_0 -> InferenceRule.lambda$propagateConstraints$123((Set)allTypes, arg_0)).collect(Collectors.toSet());
        ruleTypes.forEach(this.body::removeAtomic);
        this.body.addAtomConstraints(types);
        return this;
    }

    private InferenceRule rewriteHead() {
        Atom childAtom = this.head.getAtom();
        Atom newAtom = childAtom.rewriteToUserDefined();
        this.head.removeAtomic(childAtom);
        this.head.addAtomic(newAtom);
        return this;
    }

    private InferenceRule rewriteBody() {
        new HashSet<Atomic>(this.body.getAtoms()).stream().filter(Atomic::isAtom).map(at -> (Atom)at).filter(Atom::isRelation).filter(at -> !at.isUserDefinedName()).filter(at -> Objects.nonNull(at.getType())).filter(at -> at.getType().equals(this.head.getAtom().getType())).forEach(at -> {
            Atom rewrite = at.rewriteToUserDefined();
            this.body.removeAtomic((Atomic)at);
            this.body.addAtomic(rewrite);
        });
        return this;
    }

    public InferenceRule rewriteToUserDefined(Atom parentAtom) {
        return parentAtom.isUserDefinedName() ? this.rewriteHead().rewriteBody() : this;
    }

    public Unifier getUnifier(Atom parentAtom) {
        Atom childAtom = this.getRuleConclusionAtom();
        UnifierImpl unifier = new UnifierImpl();
        if (parentAtom.getType() != null) {
            unifier.merge(childAtom.getUnifier(parentAtom));
        } else {
            Relation extendedParent = ((Relation)AtomicFactory.create(parentAtom, parentAtom.getParentQuery())).addType(childAtom.getType());
            unifier.merge(childAtom.getUnifier(extendedParent));
        }
        return unifier;
    }

    private static /* synthetic */ boolean lambda$propagateConstraints$123(Set set, TypeAtom ta) {
        Type type = ta.getType();
        Type subType = set.stream().map(Atom::getType).filter(Objects::nonNull).filter(t -> ReasonerUtils.getSuperTypes(t).contains(type)).findFirst().orElse(null);
        return type == null || subType == null;
    }
}

