/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.utils;

import ai.grakn.GraknGraph;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.property.IdProperty;
import ai.grakn.graql.internal.pattern.property.LabelProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.utils.conversion.TypeConverter;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;

public class ReasonerUtils {
    private static final String CAPTURE_MARK = "captured-";

    public static Set<Rule> getRules(GraknGraph graph) {
        return new HashSet<Rule>(graph.admin().getMetaRuleInference().instances());
    }

    public static boolean hasRules(GraknGraph graph) {
        TypeLabel inferenceRule = Schema.MetaSchema.INFERENCE_RULE.getLabel();
        return (Boolean)graph.graql().infer(false).match(new Pattern[]{Graql.var("x").isa(Graql.label(inferenceRule))}).ask().execute();
    }

    public static Var capture(Var var) {
        return var.map(CAPTURE_MARK::concat);
    }

    public static Var uncapture(Var var) {
        return var.map(name -> name.replace(CAPTURE_MARK, ""));
    }

    public static boolean isCaptured(Var var) {
        return var.getValue().contains(CAPTURE_MARK);
    }

    public static IdPredicate getUserDefinedIdPredicate(Var typeVariable, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        return vars.stream().filter(v -> v.getVarName().equals((Object)typeVariable)).flatMap(v -> v.hasProperty(LabelProperty.class) ? v.getProperties(LabelProperty.class).map(np -> new IdPredicate(typeVariable, (LabelProperty)np, parent)) : v.getProperties(IdProperty.class).map(np -> new IdPredicate(typeVariable, (IdProperty)np, parent))).findFirst().orElse(null);
    }

    public static IdPredicate getIdPredicate(Var typeVariable, VarPatternAdmin typeVar, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        IdPredicate predicate = null;
        if (typeVar.isUserDefinedName()) {
            predicate = ReasonerUtils.getUserDefinedIdPredicate(typeVariable, vars, parent);
        } else {
            LabelProperty nameProp = typeVar.getProperty(LabelProperty.class).orElse(null);
            if (nameProp != null) {
                predicate = new IdPredicate(typeVariable, nameProp, parent);
            }
        }
        return predicate;
    }

    public static Set<ValuePredicate> getValuePredicates(Var valueVariable, VarPatternAdmin valueVar, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        HashSet<ValuePredicate> predicates = new HashSet<ValuePredicate>();
        if (valueVar.isUserDefinedName()) {
            vars.stream().filter(v -> v.getVarName().equals((Object)valueVariable)).flatMap(v -> v.getProperties(ValueProperty.class).map(vp -> new ValuePredicate(v.getVarName(), vp.getPredicate(), parent))).forEach(predicates::add);
        } else {
            valueVar.getProperties(ValueProperty.class).forEach(vp -> predicates.add(new ValuePredicate(ValuePredicate.createValueVar(valueVariable, vp.getPredicate()), parent)));
        }
        return predicates;
    }

    public static Set<Unifier> getUnifiersFromPermutations(List<Var> originalVars, List<List<Var>> permutations) {
        HashSet<Unifier> unifierSet = new HashSet<Unifier>();
        permutations.forEach(perm -> {
            UnifierImpl unifier = new UnifierImpl();
            Iterator pIt = originalVars.iterator();
            Iterator cIt = perm.iterator();
            while (pIt.hasNext() && cIt.hasNext()) {
                Var chVar;
                Var pVar = (Var)pIt.next();
                if (pVar.equals((Object)(chVar = (Var)cIt.next()))) continue;
                unifier.addMapping(pVar, chVar);
            }
            unifierSet.add(unifier);
        });
        return unifierSet;
    }

    public static <T> List<List<T>> getListPermutations(List<T> entryList) {
        if (entryList.isEmpty()) {
            ArrayList<List<T>> result = new ArrayList<List<T>>();
            result.add(new ArrayList());
            return result;
        }
        ArrayList<T> list = new ArrayList<T>(entryList);
        Object firstElement = list.remove(0);
        ArrayList<List<T>> returnValue = new ArrayList<List<T>>();
        List<List<T>> permutations = ReasonerUtils.getListPermutations(list);
        for (List<T> smallerPermuted : permutations) {
            for (int index = 0; index <= smallerPermuted.size(); ++index) {
                ArrayList<T> temp = new ArrayList<T>(smallerPermuted);
                temp.add(index, firstElement);
                returnValue.add(temp);
            }
        }
        return returnValue;
    }

    public static Set<Type> getSuperTypes(Type type) {
        HashSet<Type> superTypes = new HashSet<Type>();
        Type superType = type.superType();
        while (!Schema.MetaSchema.isMetaLabel((TypeLabel)superType.getLabel())) {
            superTypes.add(superType);
            superType = superType.superType();
        }
        return superTypes;
    }

    public static Type getTopType(Type type) {
        Type superType = type;
        while (!Schema.MetaSchema.isMetaLabel((TypeLabel)superType.getLabel())) {
            superType = superType.superType();
        }
        return superType;
    }

    public static <T extends Type> Set<T> getTopTypes(Set<T> types) {
        return types.stream().filter(rt -> Sets.intersection(ReasonerUtils.getSuperTypes(rt), (Set)types).isEmpty()).collect(Collectors.toSet());
    }

    public static Set<RoleType> getCompatibleRoleTypes(Type type, Set<RoleType> relRoles) {
        Collection typeRoles = type.plays();
        return relRoles.stream().filter(typeRoles::contains).collect(Collectors.toSet());
    }

    public static <K, V> Multimap<K, V> multimapIntersection(Multimap<K, V> m1, Multimap<K, V> m2) {
        HashMultimap intersection = HashMultimap.create();
        Sets.SetView keyIntersection = Sets.intersection((Set)m1.keySet(), (Set)m2.keySet());
        Stream.concat(m1.entries().stream(), m2.entries().stream()).filter(e -> keyIntersection.contains(e.getKey())).forEach(arg_0 -> ReasonerUtils.lambda$multimapIntersection$22((Multimap)intersection, arg_0));
        return intersection;
    }

    public static <T extends Type> Multimap<RelationType, RoleType> getCompatibleRelationTypesWithRoles(Set<T> types, TypeConverter<T> typeConverter) {
        Multimap<RelationType, RoleType> compatibleTypes = HashMultimap.create();
        if (types.isEmpty()) {
            return compatibleTypes;
        }
        Iterator<T> it = types.iterator();
        compatibleTypes.putAll(typeConverter.toRelationMultimap((Type)it.next()));
        while (it.hasNext() && compatibleTypes.size() > 1) {
            compatibleTypes = ReasonerUtils.multimapIntersection(compatibleTypes, typeConverter.toRelationMultimap((Type)it.next()));
        }
        return compatibleTypes;
    }

    public static void computeRoleCombinations(Set<Var> vars, Set<RoleType> roles, Map<Var, VarPattern> roleMap, Set<Map<Var, VarPattern>> roleMaps) {
        HashSet tempVars = Sets.newHashSet(vars);
        HashSet tempRoles = Sets.newHashSet(roles);
        Var var = vars.iterator().next();
        roles.forEach(role -> {
            tempVars.remove(var);
            tempRoles.remove(role);
            roleMap.put(var, (VarPattern)Graql.var().label(role.getLabel()).admin());
            if (!tempVars.isEmpty() && !tempRoles.isEmpty()) {
                ReasonerUtils.computeRoleCombinations(tempVars, tempRoles, roleMap, roleMaps);
            } else {
                if (!roleMap.isEmpty()) {
                    roleMaps.add(Maps.newHashMap((Map)roleMap));
                }
                roleMap.remove(var);
            }
            tempVars.add(var);
            tempRoles.add(role);
        });
    }

    public static Rule createTransitiveRule(RelationType relType, TypeLabel fromRoleLabel, TypeLabel toRoleLabel, GraknGraph graph) {
        int arity = relType.relates().size();
        if (arity != 2) {
            throw new IllegalArgumentException(ErrorMessage.RULE_CREATION_ARITY_ERROR.getMessage(new Object[0]));
        }
        VarPatternAdmin startVar = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label(fromRoleLabel), "x").rel(Graql.label(toRoleLabel), "z").admin();
        VarPatternAdmin endVar = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label(fromRoleLabel), "z").rel(Graql.label(toRoleLabel), "y").admin();
        VarPatternAdmin headVar = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label(fromRoleLabel), "x").rel(Graql.label(toRoleLabel), "y").admin();
        Conjunction body = Patterns.conjunction(Sets.newHashSet((Object[])new VarPatternAdmin[]{startVar, endVar}));
        return graph.admin().getMetaRuleInference().putRule(body, (Pattern)headVar);
    }

    public static Rule createReflexiveRule(RelationType relType, TypeLabel fromRoleLabel, TypeLabel toRoleLabel, GraknGraph graph) {
        int arity = relType.relates().size();
        if (arity != 2) {
            throw new IllegalArgumentException(ErrorMessage.RULE_CREATION_ARITY_ERROR.getMessage(new Object[0]));
        }
        VarPattern body = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label(fromRoleLabel), "x").rel(Graql.label(toRoleLabel), "y");
        VarPattern head = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label(fromRoleLabel), "x").rel(Graql.label(toRoleLabel), "x");
        return graph.admin().getMetaRuleInference().putRule((Pattern)body, (Pattern)head);
    }

    public static Rule createSubPropertyRule(RelationType parent, RelationType child, Map<TypeLabel, TypeLabel> roleMappings, GraknGraph graph) {
        int childArity;
        int parentArity = parent.relates().size();
        if (parentArity != (childArity = child.relates().size()) || parentArity != roleMappings.size()) {
            throw new IllegalArgumentException(ErrorMessage.RULE_CREATION_ARITY_ERROR.getMessage(new Object[0]));
        }
        VarPattern parentVar = Graql.var().isa(Graql.label(parent.getLabel()));
        VarPattern childVar = Graql.var().isa(Graql.label(child.getLabel()));
        for (Map.Entry<TypeLabel, TypeLabel> entry : roleMappings.entrySet()) {
            Var varName = Var.anon();
            parentVar = parentVar.rel(Graql.label(entry.getKey()), Graql.var(varName));
            childVar = childVar.rel(Graql.label(entry.getValue()), Graql.var(varName));
        }
        return graph.admin().getMetaRuleInference().putRule((Pattern)childVar, (Pattern)parentVar);
    }

    public static Rule createPropertyChainRule(RelationType relation, TypeLabel fromRoleLabel, TypeLabel toRoleLabel, LinkedHashMap<RelationType, Pair<TypeLabel, TypeLabel>> chain, GraknGraph graph) {
        Stack<Var> varNames = new Stack<Var>();
        varNames.push(Var.of((String)"x"));
        HashSet bodyVars = new HashSet();
        chain.forEach((relType, rolePair) -> {
            Var varName = Var.anon();
            VarPatternAdmin var = Graql.var().isa(Graql.label(relType.getLabel())).rel(Graql.label((TypeLabel)rolePair.getKey()), Graql.var((Var)varNames.peek())).rel(Graql.label((TypeLabel)rolePair.getValue()), Graql.var(varName)).admin();
            varNames.push(varName);
            bodyVars.add(var);
        });
        VarPattern headVar = Graql.var().isa(Graql.label(relation.getLabel())).rel(Graql.label(fromRoleLabel), "x").rel(Graql.label(toRoleLabel), Graql.var((Var)varNames.peek()));
        return graph.admin().getMetaRuleInference().putRule(Patterns.conjunction(bodyVars), (Pattern)headVar);
    }

    public static boolean checkTypesCompatible(Type parent, Type child) {
        if (Schema.MetaSchema.isMetaLabel((TypeLabel)parent.getLabel())) {
            return true;
        }
        Type superType = child;
        while (!Schema.MetaSchema.isMetaLabel((TypeLabel)superType.getLabel())) {
            if (superType.equals(parent)) {
                return true;
            }
            superType = superType.superType();
        }
        return false;
    }

    public static boolean checkTypesDisjoint(Type parent, Type child) {
        return !ReasonerUtils.checkTypesCompatible(parent, child) && !ReasonerUtils.checkTypesCompatible(child, parent);
    }

    private static /* synthetic */ void lambda$multimapIntersection$22(Multimap multimap, Map.Entry e) {
        multimap.put(e.getKey(), e.getValue());
    }
}

