/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.TypeId;
import ai.grakn.graql.internal.analytics.GraknMapReduce;
import ai.grakn.graql.internal.analytics.Utility;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class ClusterSizeMapReduce
extends GraknMapReduce<Long> {
    private static final String CLUSTER_LABEL = "clusterSizeMapReduce.clusterLabel";
    private static final String CLUSTER_SIZE = "clusterSizeMapReduce.clusterSize";

    public ClusterSizeMapReduce() {
    }

    public ClusterSizeMapReduce(Set<TypeId> selectedTypeIds, String clusterLabel) {
        super(selectedTypeIds);
        this.persistentProperties.put(CLUSTER_LABEL, clusterLabel);
    }

    public ClusterSizeMapReduce(Set<TypeId> selectedTypeIds, String clusterLabel, Long clusterSize) {
        this(selectedTypeIds, clusterLabel);
        this.persistentProperties.put(CLUSTER_SIZE, clusterSize);
    }

    @Override
    public void safeMap(Vertex vertex, MapReduce.MapEmitter<Serializable, Long> emitter) {
        if (this.selectedTypes.contains(Utility.getVertexTypeId(vertex))) {
            emitter.emit(vertex.value((String)this.persistentProperties.get(CLUSTER_LABEL)), (Object)1L);
        } else {
            emitter.emit((Object)MapReduce.NullObject.instance(), (Object)0L);
        }
    }

    @Override
    Long reduceValues(Iterator<Long> values) {
        return (Long)IteratorUtils.reduce(values, (Object)0L, (a, b) -> a + b);
    }

    @Override
    public Map<Serializable, Long> generateFinalResult(Iterator<KeyValue<Serializable, Long>> keyValues) {
        if (this.persistentProperties.containsKey(CLUSTER_SIZE)) {
            long clusterSize = (Long)this.persistentProperties.get(CLUSTER_SIZE);
            keyValues = IteratorUtils.filter(keyValues, pair -> ((Long)pair.getValue()).equals(clusterSize));
        }
        Map<Serializable, Long> clusterPopulation = Utility.keyValuesToMap(keyValues);
        clusterPopulation.remove(MapReduce.NullObject.instance());
        return clusterPopulation;
    }
}

