/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.TypeId;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.Schema;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class DegreeVertexProgram
extends GraknVertexProgram<Long> {
    public static final String DEGREE = "degreeVertexProgram.degree";
    private static final String OF_TYPE_LABELS = "degreeVertexProgram.ofTypeIds";
    Set<TypeId> ofTypeIds = new HashSet<TypeId>();
    String degreePropertyKey;

    public DegreeVertexProgram() {
    }

    public DegreeVertexProgram(Set<TypeId> types, Set<TypeId> ofTypeIds, String randomId) {
        this.selectedTypes = types;
        this.degreePropertyKey = DEGREE + randomId;
        this.ofTypeIds = ofTypeIds;
        this.persistentProperties.put(DEGREE, this.degreePropertyKey);
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        this.ofTypeIds.forEach(type -> configuration.addProperty("degreeVertexProgram.ofTypeIds." + type, type));
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        super.loadState(graph, configuration);
        configuration.subset(OF_TYPE_LABELS).getKeys().forEachRemaining(key -> this.ofTypeIds.add(TypeId.of((Integer)configuration.getInt("degreeVertexProgram.ofTypeIds." + key))));
        this.degreePropertyKey = (String)this.persistentProperties.get(DEGREE);
    }

    public Set<String> getElementComputeKeys() {
        return Collections.singleton(this.degreePropertyKey);
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                return messageScopeSetInstance;
            }
            case 1: {
                return messageScopeSetCasting;
            }
        }
        return Collections.emptySet();
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                if (!this.selectedTypes.contains(Utility.getVertexTypeId(vertex))) break;
                this.degreeStepInstance(vertex, messenger);
                break;
            }
            case 1: {
                if (!vertex.label().equals(Schema.BaseType.CASTING.name())) break;
                this.degreeStepCasting(messenger);
                break;
            }
            case 2: {
                TypeId typeId = Utility.getVertexTypeId(vertex);
                if (!this.selectedTypes.contains(typeId) || !this.ofTypeIds.contains(typeId)) break;
                vertex.property(this.degreePropertyKey, (Object)DegreeVertexProgram.getMessageCount(messenger));
                break;
            }
            default: {
                throw new RuntimeException("unreachable");
            }
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Degree Iteration " + memory.getIteration());
        return memory.getIteration() == 2;
    }
}

