/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeId;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class MedianVertexProgram
extends GraknVertexProgram<Long> {
    private static final int MAX_ITERATION = 40;
    private static final String RESOURCE_DATA_TYPE = "medianVertexProgram.resourceDataType";
    private static final String RESOURCE_TYPE = "medianVertexProgram.statisticsResourceType";
    private static final String LABEL = "medianVertexProgram.label";
    public static final String MEDIAN = "medianVertexProgram.median";
    private static final String COUNT = "medianVertexProgram.count";
    private static final String INDEX_START = "medianVertexProgram.indexStart";
    private static final String INDEX_END = "medianVertexProgram.indexEnd";
    private static final String INDEX_MEDIAN = "medianVertexProgram.indexMedian";
    private static final String PIVOT = "medianVertexProgram.pivot";
    private static final String PIVOT_POSITIVE = "medianVertexProgram.pivotPositive";
    private static final String PIVOT_NEGATIVE = "medianVertexProgram.pivotNegative";
    private static final String POSITIVE_COUNT = "medianVertexProgram.positiveCount";
    private static final String NEGATIVE_COUNT = "medianVertexProgram.negativeCount";
    private static final String FOUND = "medianVertexProgram.found";
    private static final String LABEL_SELECTED = "medianVertexProgram.labelSelected";
    private static final Set<String> MEMORY_COMPUTE_KEYS = Sets.newHashSet((Object[])new String[]{"medianVertexProgram.count", "medianVertexProgram.median", "medianVertexProgram.found", "medianVertexProgram.indexStart", "medianVertexProgram.indexEnd", "medianVertexProgram.indexMedian", "medianVertexProgram.pivot", "medianVertexProgram.pivotPositive", "medianVertexProgram.pivotNegative", "medianVertexProgram.positiveCount", "medianVertexProgram.negativeCount", "medianVertexProgram.labelSelected"});
    private Set<TypeId> statisticsResourceTypeIds = new HashSet<TypeId>();
    private String degreePropertyKey;
    private String labelKey;
    private String visitedKey;

    public MedianVertexProgram() {
    }

    public MedianVertexProgram(Set<TypeId> selectedTypeId, Set<TypeId> statisticsResourceTypeIds, ResourceType.DataType resourceDataType, String randomId) {
        this.selectedTypes = selectedTypeId;
        this.statisticsResourceTypeIds = statisticsResourceTypeIds;
        String resourceDataTypeValue = resourceDataType.equals(ResourceType.DataType.LONG) ? Schema.ConceptProperty.VALUE_LONG.name() : Schema.ConceptProperty.VALUE_DOUBLE.name();
        this.persistentProperties.put(RESOURCE_DATA_TYPE, resourceDataTypeValue);
        this.degreePropertyKey = "degreeVertexProgram.degree" + randomId;
        this.labelKey = LABEL + randomId;
        this.visitedKey = "degreeStatisticsVertexProgram.visited" + randomId;
        this.persistentProperties.put("degreeVertexProgram.degree", this.degreePropertyKey);
        this.persistentProperties.put(LABEL, this.labelKey);
        this.persistentProperties.put("degreeStatisticsVertexProgram.visited", this.visitedKey);
    }

    public Set<String> getElementComputeKeys() {
        return Sets.newHashSet((Object[])new String[]{this.degreePropertyKey, this.labelKey, this.visitedKey});
    }

    public Set<String> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                return Collections.singleton(messageScopeInRolePlayer);
            }
            case 1: {
                return Collections.singleton(messageScopeInCasting);
            }
            case 2: {
                return Collections.singleton(messageScopeOutCasting);
            }
            case 3: {
                return Collections.singleton(messageScopeOutRolePlayer);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        this.statisticsResourceTypeIds.forEach(typeId -> configuration.addProperty("medianVertexProgram.statisticsResourceType." + typeId, typeId));
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        super.loadState(graph, configuration);
        configuration.subset(RESOURCE_TYPE).getKeys().forEachRemaining(key -> this.statisticsResourceTypeIds.add(TypeId.of((Integer)configuration.getInt("medianVertexProgram.statisticsResourceType." + key))));
        this.degreePropertyKey = (String)this.persistentProperties.get("degreeVertexProgram.degree");
        this.visitedKey = (String)this.persistentProperties.get("degreeStatisticsVertexProgram.visited");
        this.labelKey = (String)this.persistentProperties.get(LABEL);
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("MedianVertexProgram Started !!!!!!!!");
        memory.set(COUNT, (Object)0L);
        memory.set(LABEL_SELECTED, (Object)memory.getIteration());
        memory.set(NEGATIVE_COUNT, (Object)0L);
        memory.set(POSITIVE_COUNT, (Object)0L);
        memory.set(FOUND, (Object)false);
        if (this.persistentProperties.get(RESOURCE_DATA_TYPE).equals(Schema.ConceptProperty.VALUE_LONG.name())) {
            memory.set(MEDIAN, (Object)0L);
            memory.set(PIVOT, (Object)0L);
            memory.set(PIVOT_NEGATIVE, (Object)0L);
            memory.set(PIVOT_POSITIVE, (Object)0L);
        } else {
            memory.set(MEDIAN, (Object)0.0);
            memory.set(PIVOT, (Object)0.0);
            memory.set(PIVOT_NEGATIVE, (Object)0.0);
            memory.set(PIVOT_POSITIVE, (Object)0.0);
        }
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepInstance(vertex, messenger, this.selectedTypes, this.statisticsResourceTypeIds);
                break;
            }
            case 1: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepCastingIn(vertex, messenger, this.visitedKey);
                break;
            }
            case 2: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepRelation(vertex, messenger);
                break;
            }
            case 3: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepCastingOut(vertex, messenger, this.visitedKey);
                break;
            }
            case 4: {
                if (!this.statisticsResourceTypeIds.contains(Utility.getVertexTypeId(vertex))) break;
                long degree = MedianVertexProgram.getMessageCount(messenger);
                vertex.property(this.degreePropertyKey, (Object)degree);
                if (degree <= 0L) break;
                memory.set(PIVOT, vertex.value((String)this.persistentProperties.get(RESOURCE_DATA_TYPE)));
                memory.incr(COUNT, degree);
                break;
            }
            case 5: {
                if (!this.statisticsResourceTypeIds.contains(Utility.getVertexTypeId(vertex)) || (Long)vertex.value(this.degreePropertyKey) <= 0L) break;
                Number value = (Number)vertex.value((String)this.persistentProperties.get(RESOURCE_DATA_TYPE));
                if (value.doubleValue() < ((Number)memory.get(PIVOT)).doubleValue()) {
                    this.updateMemoryNegative(vertex, memory, value);
                    break;
                }
                if (value.doubleValue() > ((Number)memory.get(PIVOT)).doubleValue()) {
                    this.updateMemoryPositive(vertex, memory, value);
                    break;
                }
                vertex.property(this.labelKey, (Object)0);
                break;
            }
            default: {
                if (!this.statisticsResourceTypeIds.contains(Utility.getVertexTypeId(vertex)) || (Long)vertex.value(this.degreePropertyKey) <= 0L || ((Integer)vertex.value(this.labelKey)).intValue() != ((Integer)memory.get(LABEL_SELECTED)).intValue()) break;
                Number value = (Number)vertex.value((String)this.persistentProperties.get(RESOURCE_DATA_TYPE));
                if (value.doubleValue() < ((Number)memory.get(PIVOT)).doubleValue()) {
                    this.updateMemoryNegative(vertex, memory, value);
                    break;
                }
                if (!(value.doubleValue() > ((Number)memory.get(PIVOT)).doubleValue())) break;
                this.updateMemoryPositive(vertex, memory, value);
            }
        }
    }

    private void updateMemoryPositive(Vertex vertex, Memory memory, Number value) {
        vertex.property(this.labelKey, (Object)memory.getIteration());
        memory.incr(POSITIVE_COUNT, ((Long)vertex.value(this.degreePropertyKey)).longValue());
        memory.set(PIVOT_POSITIVE, (Object)value);
    }

    private void updateMemoryNegative(Vertex vertex, Memory memory, Number value) {
        vertex.property(this.labelKey, (Object)(-memory.getIteration()));
        memory.incr(NEGATIVE_COUNT, ((Long)vertex.value(this.degreePropertyKey)).longValue());
        memory.set(PIVOT_NEGATIVE, (Object)value);
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.getIteration() == 4) {
            memory.set(INDEX_START, (Object)0L);
            memory.set(INDEX_END, (Object)((Long)memory.get(COUNT) - 1L));
            memory.set(INDEX_MEDIAN, (Object)(((Long)memory.get(COUNT) - 1L) / 2L));
            LOGGER.debug("count: " + memory.get(COUNT));
            LOGGER.debug("first pivot: " + memory.get(PIVOT));
        } else if (memory.getIteration() > 4) {
            long indexNegativeEnd = (Long)memory.get(INDEX_START) + (Long)memory.get(NEGATIVE_COUNT) - 1L;
            long indexPositiveStart = (Long)memory.get(INDEX_END) - (Long)memory.get(POSITIVE_COUNT) + 1L;
            LOGGER.debug("pivot: " + memory.get(PIVOT));
            LOGGER.debug(memory.get(INDEX_START) + ", " + indexNegativeEnd);
            LOGGER.debug(indexPositiveStart + ", " + memory.get(INDEX_END));
            LOGGER.debug("negative count: " + memory.get(NEGATIVE_COUNT));
            LOGGER.debug("positive count: " + memory.get(POSITIVE_COUNT));
            LOGGER.debug("negative pivot: " + memory.get(PIVOT_NEGATIVE));
            LOGGER.debug("positive pivot: " + memory.get(PIVOT_POSITIVE));
            if (indexNegativeEnd < (Long)memory.get(INDEX_MEDIAN)) {
                if (indexPositiveStart > (Long)memory.get(INDEX_MEDIAN)) {
                    memory.set(FOUND, (Object)true);
                    LOGGER.debug("FOUND IT!!!");
                } else {
                    memory.set(INDEX_START, (Object)indexPositiveStart);
                    memory.set(PIVOT, memory.get(PIVOT_POSITIVE));
                    memory.set(LABEL_SELECTED, (Object)memory.getIteration());
                    LOGGER.debug("new pivot: " + memory.get(PIVOT));
                }
            } else {
                memory.set(INDEX_END, (Object)indexNegativeEnd);
                memory.set(PIVOT, memory.get(PIVOT_NEGATIVE));
                memory.set(LABEL_SELECTED, (Object)(-memory.getIteration()));
                LOGGER.debug("new pivot: " + memory.get(PIVOT));
            }
            memory.set(MEDIAN, memory.get(PIVOT));
            memory.set(POSITIVE_COUNT, (Object)0L);
            memory.set(NEGATIVE_COUNT, (Object)0L);
        }
        return (Boolean)memory.get(FOUND) != false || memory.getIteration() >= 40;
    }
}

