/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.GraknGraph;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.util.CommonUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class GraqlTraversal {
    private final ImmutableSet<ImmutableList<Fragment>> fragments;
    private static final long NUM_VERTICES_ESTIMATE = 10000L;

    private GraqlTraversal(Set<? extends List<Fragment>> fragments) {
        this.fragments = fragments.stream().map(ImmutableList::copyOf).collect(CommonUtil.toImmutableSet());
    }

    static GraqlTraversal create(Set<? extends List<Fragment>> fragments) {
        return new GraqlTraversal(fragments);
    }

    public GraphTraversal<Vertex, Map<String, Vertex>> getGraphTraversal(GraknGraph graph) {
        Traversal[] traversals = (Traversal[])this.fragments.stream().map(list -> this.getConjunctionTraversal(graph, (ImmutableList<Fragment>)list)).toArray(Traversal[]::new);
        return graph.admin().getTinkerTraversal().limit(1L).union(traversals);
    }

    public ImmutableSet<ImmutableList<Fragment>> fragments() {
        return this.fragments;
    }

    private GraphTraversal<Vertex, Map<String, Vertex>> getConjunctionTraversal(GraknGraph graph, ImmutableList<Fragment> fragmentList) {
        GraphTraversal traversal = graph.admin().getTinkerTraversal();
        HashSet<Var> foundNames = new HashSet<Var>();
        Var currentName = null;
        for (Fragment fragment : fragmentList) {
            this.applyFragment(fragment, (GraphTraversal<Vertex, Vertex>)traversal, currentName, foundNames, graph);
            currentName = fragment.getEnd().orElse(fragment.getStart());
        }
        String[] traversalNames = (String[])foundNames.stream().map(Var::getValue).toArray(String[]::new);
        return traversal.select(traversalNames[0], traversalNames[0], traversalNames);
    }

    private void applyFragment(Fragment fragment, GraphTraversal<Vertex, Vertex> traversal, Var currentName, Set<Var> names, GraknGraph graph) {
        Var start = fragment.getStart();
        if (currentName != null) {
            if (!currentName.equals((Object)start)) {
                if (names.contains(start)) {
                    traversal.select(start.getValue());
                } else {
                    traversal.V(new Object[0]).as(start.getValue(), new String[0]);
                }
            }
        } else {
            traversal.as(start.getValue(), new String[0]);
        }
        names.add(start);
        fragment.applyTraversal(traversal, graph);
        fragment.getEnd().ifPresent(end -> {
            if (!names.contains(end)) {
                traversal.as(end.getValue(), new String[0]);
            } else {
                traversal.where(P.eq((Object)end.getValue()));
            }
        });
        names.addAll(fragment.getVariableNames());
    }

    public double getComplexity() {
        double totalCost = 0.0;
        for (List list : this.fragments) {
            totalCost += GraqlTraversal.fragmentListCost(list);
        }
        return totalCost;
    }

    static double fragmentListCost(List<Fragment> fragments) {
        HashSet<Var> names = new HashSet<Var>();
        double cost = 1.0;
        double listCost = 0.0;
        for (Fragment fragment : fragments) {
            cost = GraqlTraversal.fragmentCost(fragment, cost, names);
            names.addAll(fragment.getVariableNames());
            listCost += cost;
        }
        return listCost;
    }

    static double fragmentCost(Fragment fragment, double previousCost, Collection<Var> names) {
        if (names.contains(fragment.getStart())) {
            return fragment.fragmentCost(previousCost);
        }
        return fragment.fragmentCost(10000.0) * previousCost;
    }

    public String toString() {
        return "{" + this.fragments.stream().map(list -> {
            StringBuilder sb = new StringBuilder();
            Var currentName = null;
            for (Fragment fragment : list) {
                if (!fragment.getStart().equals(currentName)) {
                    if (currentName != null) {
                        sb.append(" ");
                    }
                    sb.append(fragment.getStart().shortName());
                    currentName = fragment.getStart();
                }
                sb.append(fragment.getName());
                Optional<Var> end = fragment.getEnd();
                if (!end.isPresent()) continue;
                sb.append(end.get().shortName());
                currentName = end.get();
            }
            return sb.toString();
        }).collect(Collectors.joining(", ")) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraqlTraversal that = (GraqlTraversal)o;
        return this.fragments.equals(that.fragments);
    }

    public int hashCode() {
        return this.fragments.hashCode();
    }
}

