/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.GraqlTraversal;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.Stack;

class Plan
implements Comparable<Plan> {
    private final Stack<Fragment> fragments;
    private final Stack<Double> costs;
    private final Set<EquivalentFragmentSet> fragmentSets;
    private final Multiset<Var> names;
    private double totalCost;

    private Plan(Stack<Fragment> fragments, Stack<Double> costs, Set<EquivalentFragmentSet> fragmentSets, Multiset<Var> names, double totalCost) {
        this.fragments = fragments;
        this.costs = costs;
        this.fragmentSets = fragmentSets;
        this.names = names;
        this.totalCost = totalCost;
    }

    static Plan base() {
        return new Plan(new Stack<Fragment>(), new Stack<Double>(), Sets.newHashSet(), (Multiset<Var>)HashMultiset.create(), 0.0);
    }

    public Plan copy() {
        Stack<Fragment> fragmentsCopy = new Stack<Fragment>();
        fragmentsCopy.addAll(this.fragments);
        Stack<Double> costsCopy = new Stack<Double>();
        costsCopy.addAll(this.costs);
        return new Plan(fragmentsCopy, costsCopy, Sets.newHashSet(this.fragmentSets), (Multiset<Var>)HashMultiset.create(this.names), this.totalCost);
    }

    boolean tryPush(Fragment newFragment) {
        if (!this.hasNames(newFragment.getDependencies())) {
            return false;
        }
        if (!this.fragmentSets.add(newFragment.getEquivalentFragmentSet())) {
            return false;
        }
        double cost = !this.costs.isEmpty() ? this.costs.peek() : 1.0;
        double newCost = GraqlTraversal.fragmentCost(newFragment, cost, this.names);
        this.totalCost += newCost;
        this.names.addAll(newFragment.getVariableNames());
        this.fragments.push(newFragment);
        this.costs.push(newCost);
        return true;
    }

    Fragment pop() {
        Fragment fragment = this.fragments.pop();
        this.fragmentSets.remove(fragment.getEquivalentFragmentSet());
        Multisets.removeOccurrences(this.names, fragment.getVariableNames());
        this.totalCost -= this.costs.pop().doubleValue();
        return fragment;
    }

    @Override
    public int compareTo(Plan plan) {
        return Double.compare(this.cost(), plan.cost());
    }

    public double cost() {
        return this.totalCost;
    }

    public List<Fragment> fragments() {
        return this.fragments;
    }

    public int size() {
        return this.fragments.size();
    }

    private boolean hasNames(Set<Var> names) {
        if (names.isEmpty()) {
            return true;
        }
        names = Sets.newHashSet(names);
        for (Fragment fragment : this.fragments) {
            if (!names.removeAll(fragment.getVariableNames()) || !names.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plan plan = (Plan)o;
        if (!this.fragments.equals(plan.fragments)) {
            return false;
        }
        return this.fragmentSets.equals(plan.fragmentSets);
    }

    public int hashCode() {
        int result = this.fragments.hashCode();
        result = 31 * result + this.fragmentSets.hashCode();
        return result;
    }

    public String toString() {
        return "Plan(" + GraqlTraversal.create((Set<? extends List<Fragment>>)ImmutableSet.of(this.fragments())) + ", " + this.totalCost + ")";
    }
}

