/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.internal.gremlin.fragment.DataTypeFragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.fragment.IdFragment;
import ai.grakn.graql.internal.gremlin.fragment.InHasScopeFragment;
import ai.grakn.graql.internal.gremlin.fragment.InIsaFragment;
import ai.grakn.graql.internal.gremlin.fragment.InPlaysFragment;
import ai.grakn.graql.internal.gremlin.fragment.InRelatesFragment;
import ai.grakn.graql.internal.gremlin.fragment.InShortcutFragment;
import ai.grakn.graql.internal.gremlin.fragment.InSubFragment;
import ai.grakn.graql.internal.gremlin.fragment.IsAbstractFragment;
import ai.grakn.graql.internal.gremlin.fragment.LabelFragment;
import ai.grakn.graql.internal.gremlin.fragment.NeqFragment;
import ai.grakn.graql.internal.gremlin.fragment.NotInternalFragment;
import ai.grakn.graql.internal.gremlin.fragment.OutHasScopeFragment;
import ai.grakn.graql.internal.gremlin.fragment.OutIsaFragment;
import ai.grakn.graql.internal.gremlin.fragment.OutPlaysFragment;
import ai.grakn.graql.internal.gremlin.fragment.OutRelatesFragment;
import ai.grakn.graql.internal.gremlin.fragment.OutShortcutFragment;
import ai.grakn.graql.internal.gremlin.fragment.OutSubFragment;
import ai.grakn.graql.internal.gremlin.fragment.RegexFragment;
import ai.grakn.graql.internal.gremlin.fragment.ResourceIndexFragment;
import ai.grakn.graql.internal.gremlin.fragment.ValueFragment;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.Schema;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class Fragments {
    private Fragments() {
    }

    public static Fragment inShortcut(Var rolePlayer, Var edge, Var relation, Optional<Var> roleType, Optional<Set<TypeLabel>> roleTypeLabels, Optional<Set<TypeLabel>> relationTypeLabels) {
        return new InShortcutFragment(rolePlayer, edge, relation, roleType, roleTypeLabels, relationTypeLabels);
    }

    public static Fragment outShortcut(Var relation, Var edge, Var rolePlayer, Optional<Var> roleType, Optional<Set<TypeLabel>> roleTypeLabels, Optional<Set<TypeLabel>> relationTypeLabels) {
        return new OutShortcutFragment(relation, edge, rolePlayer, roleType, roleTypeLabels, relationTypeLabels);
    }

    public static Fragment inSub(Var start, Var end) {
        return new InSubFragment(start, end);
    }

    public static Fragment outSub(Var start, Var end) {
        return new OutSubFragment(start, end);
    }

    public static InRelatesFragment inRelates(Var start, Var end) {
        return new InRelatesFragment(start, end);
    }

    public static Fragment outRelates(Var start, Var end) {
        return new OutRelatesFragment(start, end);
    }

    public static Fragment inIsa(Var start, Var end) {
        return new InIsaFragment(start, end);
    }

    public static Fragment outIsa(Var start, Var end) {
        return new OutIsaFragment(start, end);
    }

    public static Fragment inHasScope(Var start, Var end) {
        return new InHasScopeFragment(start, end);
    }

    public static Fragment outHasScope(Var start, Var end) {
        return new OutHasScopeFragment(start, end);
    }

    public static Fragment dataType(Var start, ResourceType.DataType dataType) {
        return new DataTypeFragment(start, dataType);
    }

    public static Fragment inPlays(Var start, Var end, boolean required) {
        return new InPlaysFragment(start, end, required);
    }

    public static Fragment outPlays(Var start, Var end, boolean required) {
        return new OutPlaysFragment(start, end, required);
    }

    public static Fragment id(Var start, ConceptId id) {
        return new IdFragment(start, id);
    }

    public static Fragment label(Var start, TypeLabel label) {
        return new LabelFragment(start, label);
    }

    public static Fragment value(Var start, ValuePredicateAdmin predicate) {
        return new ValueFragment(start, predicate);
    }

    public static Fragment isAbstract(Var start) {
        return new IsAbstractFragment(start);
    }

    public static Fragment regex(Var start, String regex) {
        return new RegexFragment(start, regex);
    }

    public static Fragment notInternal(Var start) {
        return new NotInternalFragment(start);
    }

    public static Fragment neq(Var start, Var other) {
        return new NeqFragment(start, other);
    }

    public static Fragment resourceIndex(Var start, TypeLabel typeLabel, Object resourceValue) {
        return new ResourceIndexFragment(start, typeLabel, resourceValue);
    }

    static GraphTraversal<Vertex, Vertex> outSubs(GraphTraversal<Vertex, Vertex> traversal) {
        return traversal.union(new Traversal[]{__.not((Traversal)__.has((String)Schema.ConceptProperty.INSTANCE_TYPE_ID.name())), __.repeat((Traversal)__.out((String[])new String[]{Schema.EdgeLabel.SUB.getLabel()})).emit()}).unfold();
    }

    static GraphTraversal<Vertex, Vertex> inSubs(GraphTraversal<Vertex, Vertex> traversal) {
        return traversal.union(new Traversal[]{__.not((Traversal)__.has((String)Schema.ConceptProperty.INSTANCE_TYPE_ID.name())), __.repeat((Traversal)__.in((String[])new String[]{Schema.EdgeLabel.SUB.getLabel()})).emit()}).unfold();
    }

    static String displayOptionalTypeLabels(String name, Optional<Set<TypeLabel>> typeLabels) {
        return typeLabels.map(labels -> " " + name + ":" + labels.stream().map(StringConverter::typeLabelToString).collect(Collectors.joining(","))).orElse("");
    }

    static void applyTypeLabelsToTraversal(GraphTraversal<Vertex, Edge> traversal, Schema.EdgeProperty property, Optional<Set<TypeLabel>> typeLabels, GraknGraph graph) {
        typeLabels.ifPresent(labels -> {
            Set typeIds = labels.stream().map(label -> graph.admin().convertToId(label).getValue()).collect(Collectors.toSet());
            traversal.has(property.name(), P.within(typeIds));
        });
    }

    static void traverseRoleTypeFromShortcutEdge(GraphTraversal<Vertex, Edge> traversal, Optional<Var> roleType) {
        roleType.ifPresent(var -> {
            Var roleTypeIdProperty = Var.anon();
            Var edge = Var.anon();
            traversal.as(edge.getValue(), new String[0]).values(new String[]{Schema.EdgeProperty.ROLE_TYPE_ID.name()}).as(roleTypeIdProperty.getValue(), new String[0]);
            GraphTraversal vertexTraversal = traversal.V(new Object[0]).has(Schema.ConceptProperty.TYPE_ID.name(), (Traversal)__.where((P)P.eq((Object)roleTypeIdProperty.getValue())));
            Fragments.outSubs((GraphTraversal<Vertex, Vertex>)vertexTraversal).as(var.getValue(), new String[0]);
            traversal.select(edge.getValue());
        });
    }
}

