/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.GraknGraph;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.util.Schema;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class InPlaysFragment
extends AbstractFragment {
    private final boolean required;

    InPlaysFragment(Var start, Var end, boolean required) {
        super(start, end, new Var[0]);
        this.required = required;
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal, GraknGraph graph) {
        if (this.required) {
            traversal.inE(new String[]{Schema.EdgeLabel.PLAYS.getLabel()}).has(Schema.EdgeProperty.REQUIRED.name()).otherV();
        } else {
            traversal.in(new String[]{Schema.EdgeLabel.PLAYS.getLabel()});
        }
        Fragments.inSubs(traversal);
    }

    @Override
    public String getName() {
        if (this.required) {
            return "<-[plays:required]-";
        }
        return "<-[plays]-";
    }

    @Override
    public double fragmentCost(double previousCost) {
        return previousCost * 3.0;
    }
}

