/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.GraknGraph;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.util.Schema;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class InShortcutFragment
extends AbstractFragment {
    private final Var edge;
    private final Optional<Var> roleType;
    private final Optional<Set<TypeLabel>> roleTypeLabels;
    private final Optional<Set<TypeLabel>> relationTypeLabels;

    InShortcutFragment(Var rolePlayer, Var edge, Var relation, Optional<Var> roleType, Optional<Set<TypeLabel>> roleTypeLabels, Optional<Set<TypeLabel>> relationTypeLabels) {
        super(rolePlayer, relation, edge, InShortcutFragment.optionalVarToArray(roleType));
        this.edge = edge;
        this.roleType = roleType;
        this.roleTypeLabels = roleTypeLabels;
        this.relationTypeLabels = relationTypeLabels;
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal, GraknGraph graph) {
        GraphTraversal edgeTraversal = traversal.inE(new String[]{Schema.EdgeLabel.SHORTCUT.getLabel()}).as(this.edge.getValue(), new String[0]);
        Fragments.applyTypeLabelsToTraversal((GraphTraversal<Vertex, Edge>)edgeTraversal, Schema.EdgeProperty.ROLE_TYPE_ID, this.roleTypeLabels, graph);
        Fragments.applyTypeLabelsToTraversal((GraphTraversal<Vertex, Edge>)edgeTraversal, Schema.EdgeProperty.RELATION_TYPE_ID, this.relationTypeLabels, graph);
        Fragments.traverseRoleTypeFromShortcutEdge((GraphTraversal<Vertex, Edge>)edgeTraversal, this.roleType);
        edgeTraversal.outV();
    }

    @Override
    public String getName() {
        String role = this.roleType.map(rt -> " role:" + rt.shortName()).orElse("");
        String rels = Fragments.displayOptionalTypeLabels("rels", this.relationTypeLabels);
        String roles = Fragments.displayOptionalTypeLabels("roles", this.roleTypeLabels);
        return "<-[shortcut:" + this.edge.shortName() + role + rels + roles + "]-";
    }

    @Override
    public double fragmentCost(double previousCost) {
        return previousCost * 30.0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InShortcutFragment that = (InShortcutFragment)o;
        if (!this.edge.equals((Object)that.edge)) {
            return false;
        }
        if (!this.roleTypeLabels.equals(that.roleTypeLabels)) {
            return false;
        }
        return this.relationTypeLabels.equals(that.relationTypeLabels);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.edge.hashCode();
        result = 31 * result + this.roleTypeLabels.hashCode();
        result = 31 * result + this.relationTypeLabels.hashCode();
        return result;
    }
}

