/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.GraknGraph;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.fragment.AbstractFragment;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.Schema;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class LabelFragment
extends AbstractFragment {
    private final TypeLabel label;

    LabelFragment(Var start, TypeLabel label) {
        super(start);
        this.label = label;
    }

    @Override
    public void applyTraversal(GraphTraversal<Vertex, Vertex> traversal, GraknGraph graph) {
        traversal.has(Schema.ConceptProperty.TYPE_ID.name(), (Object)graph.admin().convertToId(this.label).getValue());
    }

    @Override
    public String getName() {
        return "[label:" + StringConverter.typeLabelToString(this.label) + "]";
    }

    @Override
    public double fragmentCost(double previousCost) {
        return 1.0;
    }

    @Override
    public boolean hasFixedFragmentCost() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelFragment that = (LabelFragment)o;
        return this.label != null ? this.label.equals((Object)that.label) : that.label == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        return result;
    }
}

