/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.sets;

import ai.grakn.GraknGraph;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.gremlin.sets.IsaFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.LabelFragmentSet;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class ShortcutFragmentSet
extends EquivalentFragmentSet {
    private final Var relation;
    private final Var edge;
    private final Var rolePlayer;
    private final Optional<Var> roleType;
    private final Optional<Set<TypeLabel>> roleTypeLabels;
    private final Optional<Set<TypeLabel>> relationTypeLabels;

    ShortcutFragmentSet(Var relation, Var edge, Var rolePlayer, Optional<Var> roleType, Optional<Set<TypeLabel>> roleTypeLabels, Optional<Set<TypeLabel>> relationTypeLabels) {
        super(Fragments.inShortcut(rolePlayer, edge, relation, roleType, roleTypeLabels, relationTypeLabels), Fragments.outShortcut(relation, edge, rolePlayer, roleType, roleTypeLabels, relationTypeLabels));
        this.relation = relation;
        this.edge = edge;
        this.rolePlayer = rolePlayer;
        this.roleType = roleType;
        this.roleTypeLabels = roleTypeLabels;
        this.relationTypeLabels = relationTypeLabels;
    }

    static boolean applyShortcutRoleTypeOptimisation(Collection<EquivalentFragmentSet> fragmentSets, GraknGraph graph) {
        Iterable shortcuts = EquivalentFragmentSets.fragmentSetOfType(ShortcutFragmentSet.class, fragmentSets)::iterator;
        for (ShortcutFragmentSet shortcut : shortcuts) {
            LabelFragmentSet roleLabel;
            Optional<Var> roleVar = shortcut.roleType;
            if (!roleVar.isPresent() || (roleLabel = EquivalentFragmentSets.typeLabelOf(roleVar.get(), fragmentSets)) == null) continue;
            RoleType roleType = (RoleType)graph.getType(roleLabel.label());
            fragmentSets.remove(shortcut);
            fragmentSets.add(shortcut.substituteRoleTypeLabel(roleType));
            return true;
        }
        return false;
    }

    static boolean applyShortcutRelationTypeOptimisation(Collection<EquivalentFragmentSet> fragmentSets, GraknGraph graph) {
        Iterable shortcuts = EquivalentFragmentSets.fragmentSetOfType(ShortcutFragmentSet.class, fragmentSets)::iterator;
        for (ShortcutFragmentSet shortcut : shortcuts) {
            LabelFragmentSet relationLabel;
            IsaFragmentSet isa;
            if (shortcut.relationTypeLabels.isPresent() || (isa = EquivalentFragmentSets.typeInformationOf(shortcut.relation, fragmentSets)) == null || (relationLabel = EquivalentFragmentSets.typeLabelOf(isa.type(), fragmentSets)) == null) continue;
            RelationType relationType = (RelationType)graph.getType(relationLabel.label());
            fragmentSets.remove(shortcut);
            fragmentSets.add(shortcut.addRelationTypeLabel(relationType));
            return true;
        }
        return false;
    }

    private ShortcutFragmentSet substituteRoleTypeLabel(RoleType roleType) {
        Preconditions.checkState((boolean)this.roleType.isPresent());
        Preconditions.checkState((!this.roleTypeLabels.isPresent() ? 1 : 0) != 0);
        Set newRoleTypeLabels = roleType.subTypes().stream().map(Type::getLabel).collect(Collectors.toSet());
        return new ShortcutFragmentSet(this.relation, this.edge, this.rolePlayer, Optional.empty(), Optional.of(newRoleTypeLabels), this.relationTypeLabels);
    }

    private ShortcutFragmentSet addRelationTypeLabel(RelationType relationType) {
        Preconditions.checkState((!this.relationTypeLabels.isPresent() ? 1 : 0) != 0);
        Set newRelationTypeLabels = relationType.subTypes().stream().map(Type::getLabel).collect(Collectors.toSet());
        return new ShortcutFragmentSet(this.relation, this.edge, this.rolePlayer, this.roleType, this.roleTypeLabels, Optional.of(newRelationTypeLabels));
    }
}

