/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.hal;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.hal.HALConceptData;
import ai.grakn.graql.internal.hal.HALExploreInstance;
import ai.grakn.graql.internal.hal.HALExploreType;
import ai.grakn.graql.internal.hal.HALGeneratedRelation;
import ai.grakn.graql.internal.hal.HALUtils;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.explanation.RuleExplanation;
import com.theoryinpractise.halbuilder.api.ReadableRepresentation;
import com.theoryinpractise.halbuilder.api.Representation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HALBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(HALBuilder.class);
    private static final int MATCH_QUERY_FIXED_DEGREE = 0;
    private static final String ASSERTION_URL = "?keyspace=%s&query=match %s %s %s %s; %s &limitEmbedded=%s&infer=false&materialise=false";

    public static Json renderHALArrayData(MatchQuery matchQuery, int offset, int limit) {
        Collection answers = (Collection)matchQuery.execute();
        return HALBuilder.renderHALArrayData(matchQuery, answers, offset, limit, false);
    }

    public static Json renderHALArrayData(MatchQuery matchQuery, Collection<Answer> results, int offset, int limit, boolean filterInstances) {
        String keyspace = ((GraknGraph)matchQuery.admin().getGraph().get()).getKeyspace();
        HashMap<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes = new HashMap();
        if (results.iterator().hasNext()) {
            roleTypes = HALUtils.computeRoleTypesFromQuery(matchQuery, results.iterator().next());
        }
        Set<TypeLabel> typesAskedInQuery = matchQuery.admin().getTypes().stream().map(x -> x.asType().getLabel()).collect(Collectors.toSet());
        return HALBuilder.buildHALRepresentations(results, typesAskedInQuery, roleTypes, keyspace, offset, limit, filterInstances);
    }

    public static String renderHALConceptData(Concept concept, int separationDegree, String keyspace, int offset, int limit) {
        return new HALConceptData(concept, separationDegree, false, new HashSet<TypeLabel>(), keyspace, offset, limit).render();
    }

    public static String HALExploreConcept(Concept concept, String keyspace, int offset, int limit) {
        String renderedHAL = null;
        if (concept.isInstance()) {
            renderedHAL = new HALExploreInstance(concept, keyspace, offset, limit).render();
        }
        if (concept.isType()) {
            renderedHAL = new HALExploreType(concept, keyspace, offset, limit).render();
        }
        return renderedHAL;
    }

    public static Json explanationAnswersToHAL(Stream<Answer> answerStream, int limit) {
        Json conceptsArray = Json.array();
        answerStream.forEach(answer -> {
            AnswerExplanation expl = answer.getExplanation();
            if (expl.isLookupExplanation()) {
                HALBuilder.renderHALArrayData(expl.getQuery().getMatchQuery(), Collections.singletonList(answer), 0, limit, true).asList().forEach(arg_0 -> ((Json)conceptsArray).add(arg_0));
            } else if (expl.isRuleExplanation()) {
                Atom innerAtom = ((RuleExplanation)expl).getRule().getHead().getAtom();
                if (innerAtom.isRelation()) {
                    HALBuilder.renderHALArrayData(expl.getQuery().getMatchQuery(), Collections.singletonList(answer), 0, limit, true).asList().forEach(arg_0 -> ((Json)conceptsArray).add(arg_0));
                }
                HALBuilder.explanationAnswersToHAL(expl.getAnswers().stream(), limit).asList().forEach(arg_0 -> ((Json)conceptsArray).add(arg_0));
            }
        });
        return conceptsArray;
    }

    private static Json buildHALRepresentations(Collection<Answer> graqlResultsList, Set<TypeLabel> typesAskedInQuery, Map<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes, String keyspace, int offset, int limit, boolean filterInstances) {
        Json lines = Json.array();
        graqlResultsList.forEach(answer -> {
            Map<VarPatternAdmin, Boolean> inferredRelations = HALUtils.buildInferredRelationsMap(answer);
            HashMap<Var, Representation> mapFromVarNameToHALObject = new HashMap<Var, Representation>();
            Stream<Object> entriesStream = answer.map().entrySet().stream();
            if (filterInstances) {
                entriesStream = entriesStream.filter(entry -> ((Concept)entry.getValue()).isInstance());
            }
            entriesStream.forEach(currentMapEntry -> {
                Concept currentConcept = (Concept)currentMapEntry.getValue();
                LOG.trace("Building HAL resource for concept with id {}", (Object)currentConcept.getId().getValue());
                Representation currentHal = new HALConceptData(currentConcept, 0, true, typesAskedInQuery, keyspace, offset, limit).getRepresentation();
                mapFromVarNameToHALObject.put((Var)currentMapEntry.getKey(), currentHal);
                lines.add(Json.read((String)currentHal.toString("application/hal+json")));
            });
            mapFromVarNameToHALObject.values().forEach(hal -> hal.withProperty("_direction", (Object)"OUT"));
            HALBuilder.loopThroughRelations(roleTypes, mapFromVarNameToHALObject, answer.map(), keyspace, limit, inferredRelations).forEach(generatedRelation -> lines.add(Json.read((String)generatedRelation.toString("application/hal+json"))));
        });
        return lines;
    }

    private static Collection<Representation> loopThroughRelations(Map<VarPatternAdmin, Pair<Map<Var, String>, String>> roleTypes, Map<Var, Representation> mapFromVarNameToHALObject, Map<Var, Concept> resultLine, String keyspace, int limit, Map<VarPatternAdmin, Boolean> inferredRelations) {
        ArrayList<Representation> generatedRelations = new ArrayList<Representation>();
        roleTypes.entrySet().forEach(currentEntry -> {
            Set<Var> varNamesInCurrentRelation = ((Map)((Pair)currentEntry.getValue()).getKey()).keySet();
            String idsList = varNamesInCurrentRelation.stream().map(key -> ((Concept)resultLine.get(key)).getId().getValue()).sorted().collect(Collectors.joining(""));
            String relationId = "temp-assertion-" + idsList;
            String relationType = (String)((Pair)currentEntry.getValue()).getValue();
            boolean isInferred = inferredRelations.containsKey(currentEntry.getKey()) && (Boolean)inferredRelations.get(currentEntry.getKey()) != false;
            String relationHref = HALBuilder.computeRelationHref(relationType, varNamesInCurrentRelation, resultLine, (Map)((Pair)currentEntry.getValue()).getKey(), keyspace, limit, isInferred);
            Representation genRelation = new HALGeneratedRelation().getNewGeneratedRelation(relationId, relationHref, relationType, isInferred);
            varNamesInCurrentRelation.forEach(varName -> genRelation.withRepresentation((String)((Map)((Pair)currentEntry.getValue()).getKey()).get(varName), (ReadableRepresentation)mapFromVarNameToHALObject.get(varName)));
            generatedRelations.add(genRelation);
        });
        return generatedRelations;
    }

    private static String computeRelationHref(String relationType, Collection<Var> varNamesInCurrentRelation, Map<Var, Concept> resultLine, Map<Var, String> varNameToRole, String keyspace, int limit, boolean isInferred) {
        String isaString = !relationType.equals("") ? "isa " + relationType : "";
        StringBuilder stringBuilderVarsWithIds = new StringBuilder();
        StringBuilder stringBuilderParenthesis = new StringBuilder().append('(');
        char currentVarLetter = 'a';
        for (Var varName : varNamesInCurrentRelation) {
            String id = resultLine.get(varName).getId().getValue();
            stringBuilderVarsWithIds.append(" $").append(currentVarLetter).append(" id '").append(id).append("';");
            String role = varNameToRole.get(varName).equals("EMPTY-GRAKN-ROLE") ? "" : varNameToRole.get(varName) + ":";
            char c = currentVarLetter;
            currentVarLetter = (char)(currentVarLetter + '\u0001');
            stringBuilderParenthesis.append(role).append("$").append(c).append(",");
        }
        String varsWithIds = stringBuilderVarsWithIds.toString();
        String parenthesis = stringBuilderParenthesis.deleteCharAt(stringBuilderParenthesis.length() - 1).append(')').toString();
        String dollarR = isInferred ? "" : "$r";
        String selectR = isInferred ? "" : "select $r;";
        String withoutUrl = String.format(ASSERTION_URL, keyspace, varsWithIds, dollarR, parenthesis, isaString, selectR, limit);
        String URL2 = isInferred ? "/dashboard/explain/" : "/graph/graql";
        return URL2 + withoutUrl;
    }
}

