/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.Disjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;

class DisjunctionImpl<T extends PatternAdmin>
implements Disjunction<T> {
    private final Set<T> patterns;

    DisjunctionImpl(Set<T> patterns) {
        this.patterns = patterns;
    }

    public Set<T> getPatterns() {
        return this.patterns;
    }

    public Disjunction<Conjunction<VarPatternAdmin>> getDisjunctiveNormalForm() {
        Set dnf = this.patterns.stream().flatMap(p -> p.getDisjunctiveNormalForm().getPatterns().stream()).collect(Collectors.toSet());
        return Patterns.disjunction(dnf);
    }

    public Set<Var> commonVarNames() {
        return this.patterns.stream().map(PatternAdmin::commonVarNames).reduce(Sets::intersection).orElse((Set)ImmutableSet.of());
    }

    public boolean isDisjunction() {
        return true;
    }

    public Disjunction<?> asDisjunction() {
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof DisjunctionImpl && this.patterns.equals(((DisjunctionImpl)obj).patterns);
    }

    public int hashCode() {
        return this.patterns.hashCode();
    }

    public String toString() {
        return this.patterns.stream().map(Object::toString).collect(Collectors.joining(" or "));
    }

    public PatternAdmin admin() {
        return this;
    }
}

