/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.concept.Concept;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.NeqProperty;
import ai.grakn.graql.internal.pattern.property.PlaysProperty;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class HasResourceTypeProperty
extends AbstractVarProperty
implements NamedProperty {
    private final VarPatternAdmin resourceType;
    private final VarPatternAdmin ownerRole;
    private final VarPatternAdmin valueRole;
    private final VarPatternAdmin relationOwner;
    private final VarPatternAdmin relationValue;
    private final boolean required;

    public HasResourceTypeProperty(VarPatternAdmin resourceType, boolean required) {
        this.resourceType = resourceType;
        this.required = required;
        TypeLabel resourceTypeLabel = (TypeLabel)resourceType.getTypeLabel().orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_LABEL_SPECIFIED_FOR_HAS.getMessage(new Object[0])));
        VarPattern role = Graql.label(Schema.MetaSchema.ROLE.getLabel());
        VarPattern ownerRole = Graql.var().sub(role);
        VarPattern valueRole = Graql.var().sub(role);
        VarPattern relationType = Graql.var().sub(Graql.label(Schema.MetaSchema.RELATION.getLabel()));
        if (required) {
            ownerRole = ownerRole.label(Schema.ImplicitType.KEY_OWNER.getLabel(resourceTypeLabel));
            valueRole = valueRole.label(Schema.ImplicitType.KEY_VALUE.getLabel(resourceTypeLabel));
            relationType = relationType.label(Schema.ImplicitType.KEY.getLabel(resourceTypeLabel));
        }
        this.ownerRole = ownerRole.admin();
        this.valueRole = valueRole.admin();
        this.relationOwner = relationType.relates((VarPattern)this.ownerRole).admin();
        this.relationValue = Graql.var(relationType.admin().getVarName()).relates((VarPattern)this.valueRole).admin();
    }

    public VarPatternAdmin getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getName() {
        return this.required ? "key" : "has";
    }

    @Override
    public String getProperty() {
        return this.resourceType.getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        HashSet<EquivalentFragmentSet> traversals = new HashSet<EquivalentFragmentSet>();
        traversals.addAll(new PlaysProperty(this.ownerRole, this.required).match(start));
        traversals.addAll(new PlaysProperty(this.valueRole, false).match(this.resourceType.getVarName()));
        traversals.addAll(new NeqProperty(this.ownerRole).match(this.valueRole.getVarName()));
        return traversals;
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(this.resourceType);
    }

    @Override
    public Stream<VarPatternAdmin> getInnerVars() {
        return Stream.of(this.resourceType);
    }

    @Override
    public Stream<VarPatternAdmin> getImplicitInnerVars() {
        return Stream.of(this.resourceType, this.ownerRole, this.valueRole, this.relationOwner, this.relationValue);
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        Type entityTypeConcept = concept.asType();
        ResourceType resourceTypeConcept = insertQueryExecutor.getConcept(this.resourceType).asResourceType();
        if (this.required) {
            entityTypeConcept.key(resourceTypeConcept);
        } else {
            entityTypeConcept.resource(resourceTypeConcept);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasResourceTypeProperty that = (HasResourceTypeProperty)o;
        return this.resourceType.equals(that.resourceType);
    }

    public int hashCode() {
        return this.resourceType.hashCode();
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        Var varName = var.getVarName();
        TypeLabel typeLabel = this.getResourceType().getTypeLabel().orElse(null);
        VarPatternAdmin resVar = Graql.var(varName).has(Graql.label(typeLabel)).admin();
        return new TypeAtom(resVar, parent);
    }
}

