/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.pattern.property.RelationProperty;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;

public class IsaProperty
extends AbstractVarProperty
implements UniqueVarProperty,
NamedProperty {
    private final VarPatternAdmin type;

    public IsaProperty(VarPatternAdmin type) {
        this.type = type;
    }

    public VarPatternAdmin getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return "isa";
    }

    @Override
    public String getProperty() {
        return this.type.getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        return ImmutableSet.of((Object)EquivalentFragmentSets.isa(start, this.type.getVarName()));
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(this.type);
    }

    @Override
    public Stream<VarPatternAdmin> getInnerVars() {
        return Stream.of(this.type);
    }

    @Override
    public void checkValidProperty(GraknGraph graph, VarPatternAdmin var) throws IllegalStateException {
        this.type.getTypeLabel().ifPresent(typeLabel -> {
            Type theType = graph.getType(typeLabel);
            if (theType != null && theType.isRoleType()) {
                throw new IllegalStateException(ErrorMessage.INSTANCE_OF_ROLE_TYPE.getMessage(new Object[]{typeLabel}));
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsaProperty that = (IsaProperty)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        if (var.hasProperty(RelationProperty.class)) {
            return null;
        }
        Var varName = var.getVarName();
        VarPatternAdmin typeVar = this.getType();
        Var typeVariable = typeVar.getVarName();
        IdPredicate predicate = ReasonerUtils.getIdPredicate(typeVariable, typeVar, vars, parent);
        VarPatternAdmin resVar = Graql.var(varName).isa(Graql.var(typeVariable)).admin();
        return new TypeAtom(resVar, predicate, parent);
    }
}

