/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern.property;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.pattern.property.AbstractVarProperty;
import ai.grakn.graql.internal.pattern.property.NamedProperty;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;

public class PlaysProperty
extends AbstractVarProperty
implements NamedProperty {
    private final VarPatternAdmin role;
    private final boolean required;

    public PlaysProperty(VarPatternAdmin role, boolean required) {
        this.role = role;
        this.required = required;
    }

    public VarPatternAdmin getRole() {
        return this.role;
    }

    @Override
    public String getName() {
        return "plays";
    }

    @Override
    public String getProperty() {
        return this.role.getPrintableName();
    }

    @Override
    public Collection<EquivalentFragmentSet> match(Var start) {
        return ImmutableSet.of((Object)EquivalentFragmentSets.plays(start, this.role.getVarName(), this.required));
    }

    @Override
    public Stream<VarPatternAdmin> getTypes() {
        return Stream.of(this.role);
    }

    @Override
    public Stream<VarPatternAdmin> getInnerVars() {
        return Stream.of(this.role);
    }

    @Override
    public void insert(InsertQueryExecutor insertQueryExecutor, Concept concept) throws IllegalStateException {
        RoleType roleType = insertQueryExecutor.getConcept(this.role).asRoleType();
        concept.asType().plays(roleType);
    }

    @Override
    public void delete(GraknGraph graph, Concept concept) {
        TypeLabel roleLabel = (TypeLabel)this.role.getTypeLabel().orElseThrow(() -> PlaysProperty.failDelete(this));
        concept.asType().deletePlays((RoleType)graph.getType(roleLabel));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaysProperty that = (PlaysProperty)o;
        return this.required == that.required && this.role.equals(that.role);
    }

    public int hashCode() {
        int result = this.role.hashCode();
        result = 31 * result + (this.required ? 1 : 0);
        return result;
    }

    public Atomic mapToAtom(VarPatternAdmin var, Set<VarPatternAdmin> vars, ReasonerQuery parent) {
        Var varName = var.getVarName();
        VarPatternAdmin typeVar = this.getRole();
        Var typeVariable = typeVar.getVarName();
        IdPredicate predicate = ReasonerUtils.getIdPredicate(typeVariable, typeVar, vars, parent);
        VarPatternAdmin resVar = Graql.var(varName).plays(Graql.var(typeVariable)).admin();
        return new TypeAtom(resVar, predicate, parent);
    }
}

