/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknGraph;
import ai.grakn.graql.AskQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Printer;
import ai.grakn.graql.admin.AskQueryAdmin;
import java.util.stream.Stream;

class AskQueryImpl
implements AskQueryAdmin {
    private final MatchQuery matchQuery;

    AskQueryImpl(MatchQuery matchQuery) {
        this.matchQuery = matchQuery;
    }

    public Boolean execute() {
        return this.matchQuery.iterator().hasNext();
    }

    public Stream<String> resultsString(Printer printer) {
        return Stream.of(printer.graqlString((Object)this.execute()));
    }

    public boolean isReadOnly() {
        return true;
    }

    public AskQuery withGraph(GraknGraph graph) {
        return new AskQueryImpl(this.matchQuery.withGraph(graph));
    }

    public AskQueryAdmin admin() {
        return this;
    }

    public String toString() {
        return this.matchQuery.toString() + " ask;";
    }

    public MatchQuery getMatchQuery() {
        return this.matchQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AskQueryImpl askQuery = (AskQueryImpl)o;
        return this.matchQuery.equals(askQuery.matchQuery);
    }

    public int hashCode() {
        return this.matchQuery.hashCode();
    }
}

