/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.property.DataTypeProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.LhsProperty;
import ai.grakn.graql.internal.pattern.property.RhsProperty;
import ai.grakn.graql.internal.pattern.property.SubProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class InsertQueryExecutor {
    private final GraknGraph graph;
    private final Collection<VarPatternAdmin> vars;
    private final Map<Var, Concept> concepts = new HashMap<Var, Concept>();
    private final Map<Var, Concept> namedConcepts = new HashMap<Var, Concept>();
    private final Stack<Var> visitedVars = new Stack();
    private final ImmutableMap<Var, List<VarPatternAdmin>> varsByVarName;
    private final ImmutableMap<TypeLabel, List<VarPatternAdmin>> varsByTypeLabel;
    private final ImmutableMap<ConceptId, List<VarPatternAdmin>> varsById;

    InsertQueryExecutor(Collection<VarPatternAdmin> vars, GraknGraph graph) {
        this.vars = vars;
        this.graph = graph;
        this.varsByVarName = ImmutableMap.copyOf(vars.stream().collect(Collectors.groupingBy(VarPatternAdmin::getVarName)));
        this.varsById = ImmutableMap.copyOf(vars.stream().filter(var -> var.getId().isPresent()).collect(Collectors.groupingBy(var -> (ConceptId)var.getId().get())));
        this.varsByTypeLabel = ImmutableMap.copyOf(vars.stream().filter(var -> var.getTypeLabel().isPresent()).collect(Collectors.groupingBy(var -> (TypeLabel)var.getTypeLabel().get())));
    }

    Answer insertAll() {
        return this.insertAll(new QueryAnswer());
    }

    Answer insertAll(Answer results) {
        this.concepts.clear();
        this.concepts.putAll(results.map());
        this.namedConcepts.clear();
        this.namedConcepts.putAll(results.map());
        this.vars.forEach(this::insertVar);
        return new QueryAnswer(this.namedConcepts);
    }

    private void insertVar(VarPatternAdmin var) {
        Concept concept = this.getConcept(var);
        var.getProperties().forEach(property -> ((VarPropertyInternal)property).insert(this, concept));
    }

    public GraknGraph getGraph() {
        return this.graph;
    }

    public Concept getConcept(VarPatternAdmin var) {
        Var name = var.getVarName();
        if (this.visitedVars.contains(name)) {
            throw new IllegalStateException(ErrorMessage.INSERT_RECURSIVE.getMessage(new Object[]{var.getPrintableName()}));
        }
        this.visitedVars.push(name);
        Concept concept = this.concepts.computeIfAbsent(name, n -> this.addConcept(var));
        assert (concept != null) : var;
        if (var.isUserDefinedName()) {
            this.namedConcepts.put(name, concept);
        }
        this.visitedVars.pop();
        return concept;
    }

    private Concept addConcept(VarPatternAdmin varToAdd) {
        VarPatternAdmin var = this.mergeVar(varToAdd);
        Optional type = var.getProperty(IsaProperty.class);
        Optional sub = var.getProperty(SubProperty.class);
        if (type.isPresent() && sub.isPresent()) {
            String printableName = var.getPrintableName();
            throw new IllegalStateException(ErrorMessage.INSERT_ISA_AND_SUB.getMessage(new Object[]{printableName}));
        }
        Optional typeLabel = var.getTypeLabel();
        Optional id = var.getId();
        typeLabel.ifPresent(label -> {
            if (type.isPresent()) {
                throw new IllegalStateException(ErrorMessage.INSERT_INSTANCE_WITH_NAME.getMessage(new Object[]{label}));
            }
        });
        if (sub.isPresent()) {
            TypeLabel label2 = this.getTypeLabelOrThrow(typeLabel);
            return this.putType(label2, var, (SubProperty)sub.get());
        }
        if (type.isPresent()) {
            return this.putInstance(id, var, (IsaProperty)type.get());
        }
        if (id.isPresent()) {
            Concept concept = this.graph.getConcept((ConceptId)id.get());
            if (concept == null) {
                throw new IllegalStateException(ErrorMessage.INSERT_WITHOUT_TYPE.getMessage(new Object[]{id.get()}));
            }
            return concept;
        }
        if (typeLabel.isPresent()) {
            Type concept = this.graph.getType((TypeLabel)typeLabel.get());
            if (concept == null) {
                throw new IllegalStateException(ErrorMessage.LABEL_NOT_FOUND.getMessage(new Object[]{typeLabel.get()}));
            }
            return concept;
        }
        throw new IllegalStateException(ErrorMessage.INSERT_UNDEFINED_VARIABLE.getMessage(new Object[]{var.getPrintableName()}));
    }

    private VarPatternAdmin mergeVar(VarPatternAdmin var) {
        boolean changed = true;
        HashSet<VarPatternAdmin> varsToMerge = new HashSet<VarPatternAdmin>();
        while (changed) {
            List vars = (List)this.varsByVarName.getOrDefault((Object)var.getVarName(), (Object)Lists.newArrayList());
            vars.add(var);
            boolean byVarNameChange = varsToMerge.addAll(vars);
            var = Patterns.mergeVars(varsToMerge);
            boolean byIdChange = var.getId().map(id -> varsToMerge.addAll((Collection)this.varsById.get(id))).orElse(false);
            var = Patterns.mergeVars(varsToMerge);
            boolean byTypeLabelChange = var.getTypeLabel().map(id -> varsToMerge.addAll((Collection)this.varsByTypeLabel.get(id))).orElse(false);
            var = Patterns.mergeVars(varsToMerge);
            changed = byVarNameChange | byIdChange | byTypeLabelChange;
        }
        return var;
    }

    private Instance putInstance(Optional<ConceptId> id, VarPatternAdmin var, IsaProperty isa) {
        Type type = this.getConcept(isa.getType()).asType();
        if (type.isEntityType()) {
            return this.addOrGetInstance(id, () -> ((EntityType)type.asEntityType()).addEntity());
        }
        if (type.isRelationType()) {
            return this.addOrGetInstance(id, () -> ((RelationType)type.asRelationType()).addRelation());
        }
        if (type.isResourceType()) {
            return this.addOrGetInstance(id, () -> type.asResourceType().putResource(this.getValue(var)));
        }
        if (type.isRuleType()) {
            return this.addOrGetInstance(id, () -> {
                LhsProperty lhs = (LhsProperty)var.getProperty(LhsProperty.class).orElseThrow(() -> new IllegalStateException(ErrorMessage.INSERT_RULE_WITHOUT_LHS.getMessage(new Object[]{var})));
                RhsProperty rhs = (RhsProperty)var.getProperty(RhsProperty.class).orElseThrow(() -> new IllegalStateException(ErrorMessage.INSERT_RULE_WITHOUT_RHS.getMessage(new Object[]{var})));
                return type.asRuleType().putRule(lhs.getPattern(), rhs.getPattern());
            });
        }
        if (type.getLabel().equals((Object)Schema.MetaSchema.CONCEPT.getLabel())) {
            throw new IllegalStateException(var + " cannot be an instance of meta-type " + type.getLabel());
        }
        throw new RuntimeException("Unrecognized type " + type.getLabel());
    }

    private Type putType(TypeLabel label, VarPatternAdmin var, SubProperty sub) {
        Type superType = this.getConcept(sub.getSuperType()).asType();
        if (superType.isEntityType()) {
            return this.graph.putEntityType(label).superType(superType.asEntityType());
        }
        if (superType.isRelationType()) {
            return this.graph.putRelationType(label).superType(superType.asRelationType());
        }
        if (superType.isRoleType()) {
            return this.graph.putRoleType(label).superType(superType.asRoleType());
        }
        if (superType.isResourceType()) {
            return this.graph.putResourceType(label, this.getDataType(var)).superType(superType.asResourceType());
        }
        if (superType.isRuleType()) {
            return this.graph.putRuleType(label).superType(superType.asRuleType());
        }
        throw new IllegalStateException(ErrorMessage.INSERT_METATYPE.getMessage(new Object[]{label, superType.getLabel()}));
    }

    private <T extends Type, S extends Instance> S addOrGetInstance(Optional<ConceptId> id, Supplier<S> addInstance) {
        return (S)id.map(arg_0 -> ((GraknGraph)this.graph).getConcept(arg_0)).orElseGet(addInstance);
    }

    private TypeLabel getTypeLabelOrThrow(Optional<TypeLabel> label) throws IllegalStateException {
        return label.orElseThrow(() -> new IllegalStateException(ErrorMessage.INSERT_TYPE_WITHOUT_LABEL.getMessage(new Object[0])));
    }

    private Object getValue(VarPatternAdmin var) {
        Iterator properties = var.getProperties(ValueProperty.class).iterator();
        if (properties.hasNext()) {
            Object value = ((ValueProperty)properties.next()).getPredicate().equalsValue().get();
            if (properties.hasNext()) {
                throw new IllegalStateException(ErrorMessage.INSERT_MULTIPLE_VALUES.getMessage(new Object[]{value, ((ValueProperty)properties.next()).getPredicate()}));
            }
            return value;
        }
        throw new IllegalStateException(ErrorMessage.INSERT_RESOURCE_WITHOUT_VALUE.getMessage(new Object[0]));
    }

    private ResourceType.DataType<?> getDataType(VarPatternAdmin var) {
        Optional<ResourceType.DataType> directDataType = var.getProperty(DataTypeProperty.class).map(DataTypeProperty::getDataType);
        Optional<ResourceType.DataType> indirectDataType = this.getSub(var).map(sub -> this.getConcept((VarPatternAdmin)sub).asResourceType().getDataType());
        Optional dataType = CommonUtil.optionalOr(directDataType, indirectDataType);
        return (ResourceType.DataType)dataType.orElseThrow(() -> new IllegalStateException(ErrorMessage.INSERT_NO_DATATYPE.getMessage(new Object[]{var.getPrintableName()})));
    }

    private Optional<VarPatternAdmin> getSub(VarPatternAdmin var) {
        return var.getProperty(SubProperty.class).map(SubProperty::getSuperType);
    }
}

