/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Type;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Printer;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.InsertQueryAdmin;
import ai.grakn.graql.admin.MatchQueryAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.query.InsertQueryExecutor;
import ai.grakn.graql.internal.query.Queries;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableCollection;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class InsertQueryImpl
implements InsertQueryAdmin {
    private final Optional<MatchQueryAdmin> matchQuery;
    private final Optional<GraknGraph> graph;
    private final ImmutableCollection<VarPatternAdmin> originalVars;
    private final ImmutableCollection<VarPatternAdmin> vars;

    InsertQueryImpl(ImmutableCollection<VarPatternAdmin> vars, Optional<MatchQueryAdmin> matchQuery, Optional<GraknGraph> graph) {
        assert (!matchQuery.isPresent() || !graph.isPresent());
        if (vars.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessage.NO_PATTERNS.getMessage(new Object[0]));
        }
        this.matchQuery = matchQuery;
        this.graph = graph;
        this.originalVars = vars;
        this.vars = (ImmutableCollection)vars.stream().flatMap(v -> v.getInnerVars().stream()).collect(CommonUtil.toImmutableList());
        for (VarPatternAdmin var : this.vars) {
            var.getProperties().forEach(property -> ((VarPropertyInternal)property).checkInsertable(var));
        }
    }

    public InsertQuery withGraph(GraknGraph graph) {
        return (InsertQuery)this.matchQuery.map(m -> Queries.insert(this.vars, m.withGraph(graph).admin())).orElseGet(() -> new InsertQueryImpl(this.vars, Optional.empty(), Optional.of(graph)));
    }

    public List<Answer> execute() {
        return this.stream().collect(Collectors.toList());
    }

    public Stream<String> resultsString(Printer printer) {
        return this.stream().map(arg_0 -> ((Printer)printer).graqlString(arg_0));
    }

    public boolean isReadOnly() {
        return false;
    }

    public Stream<Answer> stream() {
        GraknGraph theGraph = this.getGraph().orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0])));
        InsertQueryExecutor executor = new InsertQueryExecutor((Collection<VarPatternAdmin>)this.vars, theGraph);
        return this.matchQuery.map(query -> query.stream().map(executor::insertAll)).orElseGet(() -> Stream.of(executor.insertAll()));
    }

    public InsertQueryAdmin admin() {
        return this;
    }

    public Optional<? extends MatchQuery> getMatchQuery() {
        return this.matchQuery;
    }

    public Set<Type> getTypes() {
        GraknGraph theGraph = this.getGraph().orElseThrow(() -> new IllegalStateException(ErrorMessage.NO_GRAPH.getMessage(new Object[0])));
        Set<Type> types = this.vars.stream().flatMap(v -> v.getInnerVars().stream()).map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).map(arg_0 -> ((GraknGraph)theGraph).getType(arg_0)).collect(Collectors.toSet());
        this.matchQuery.ifPresent(mq -> types.addAll(mq.getTypes()));
        return types;
    }

    public Collection<VarPatternAdmin> getVars() {
        return this.originalVars;
    }

    public Optional<GraknGraph> getGraph() {
        return this.matchQuery.map(MatchQueryAdmin::getGraph).orElse(this.graph);
    }

    public String toString() {
        String mq = this.matchQuery.map(match -> match + "\n").orElse("");
        return mq + "insert " + this.originalVars.stream().map(v -> v + ";").collect(Collectors.joining("\n")).trim();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertQueryImpl maps = (InsertQueryImpl)o;
        if (!this.matchQuery.equals(maps.matchQuery)) {
            return false;
        }
        if (!this.graph.equals(maps.graph)) {
            return false;
        }
        return this.originalVars.equals(maps.originalVars);
    }

    public int hashCode() {
        int result = this.matchQuery.hashCode();
        result = 31 * result + this.graph.hashCode();
        result = 31 * result + this.originalVars.hashCode();
        return result;
    }
}

