/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.reasoner.explanation.Explanation;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryAnswer
implements Answer {
    private final Map<Var, Concept> map = new HashMap<Var, Concept>();
    private AnswerExplanation explanation = new Explanation();

    public QueryAnswer() {
    }

    public QueryAnswer(Answer a) {
        this.map.putAll(a.map());
        this.explanation = a.getExplanation();
    }

    public QueryAnswer(Map<Var, Concept> m) {
        this.map.putAll(m);
    }

    public String toString() {
        return this.map.entrySet().stream().sorted(Comparator.comparing(e -> ((Var)e.getKey()).getValue())).map(e -> "[" + e.getKey() + "/" + ((Concept)e.getValue()).getId() + "]").collect(Collectors.joining());
    }

    public Answer copy() {
        return new QueryAnswer(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Answer)) {
            return false;
        }
        QueryAnswer a2 = (QueryAnswer)obj;
        return this.map.equals(a2.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public Set<Var> keySet() {
        return this.map.keySet();
    }

    public Collection<Concept> values() {
        return this.map.values();
    }

    public Set<Concept> concepts() {
        return this.map.values().stream().collect(Collectors.toSet());
    }

    public Set<Map.Entry<Var, Concept>> entrySet() {
        return this.map.entrySet();
    }

    public Concept get(String var) {
        return this.map.get(Var.of((String)var));
    }

    public Concept get(Var var) {
        return this.map.get(var);
    }

    public Concept put(Var var, Concept con) {
        return this.map.put(var, con);
    }

    public Concept remove(Var var) {
        return this.map.remove(var);
    }

    public Map<Var, Concept> map() {
        return this.map;
    }

    public void putAll(Answer a) {
        this.map.putAll(a.map());
    }

    public void putAll(Map<Var, Concept> m2) {
        this.map.putAll(m2);
    }

    public boolean containsKey(Var var) {
        return this.map.containsKey(var);
    }

    public boolean containsAll(Answer ans) {
        return this.map.entrySet().containsAll(ans.map().entrySet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public void forEach(BiConsumer<? super Var, ? super Concept> consumer) {
        this.map.forEach(consumer);
    }

    public Answer merge(Answer a2, boolean mergeExplanation) {
        if (a2.isEmpty()) {
            return this;
        }
        AnswerExplanation exp = this.getExplanation();
        QueryAnswer merged = new QueryAnswer(a2);
        merged.putAll(this);
        if (mergeExplanation) {
            exp = exp.merge(a2.getExplanation());
            if (!this.getExplanation().isJoinExplanation()) {
                exp.addAnswer((Answer)this);
            }
            if (!a2.getExplanation().isJoinExplanation()) {
                exp.addAnswer(a2);
            }
        }
        return merged.setExplanation(exp);
    }

    public Answer merge(Answer a2) {
        return this.merge(a2, false);
    }

    public Answer explain(AnswerExplanation exp) {
        Set answers = this.explanation.getAnswers();
        this.explanation = exp;
        answers.forEach(arg_0 -> ((AnswerExplanation)this.explanation).addAnswer(arg_0));
        return this;
    }

    public Answer filterVars(Set<Var> vars) {
        QueryAnswer filteredAnswer = new QueryAnswer(this);
        Sets.SetView varsToRemove = Sets.difference(this.keySet(), vars);
        varsToRemove.forEach(filteredAnswer::remove);
        return filteredAnswer.setExplanation(this.getExplanation());
    }

    public Answer unify(Unifier unifier) {
        if (unifier.isEmpty()) {
            return this;
        }
        QueryAnswer unified = new QueryAnswer();
        HashMultimap answerMultimap = HashMultimap.create();
        this.entrySet().forEach(arg_0 -> QueryAnswer.lambda$unify$3(unifier, (Multimap)answerMultimap, arg_0));
        if (answerMultimap.keySet().size() == answerMultimap.values().size()) {
            answerMultimap.entries().forEach((? super T e) -> unified.put((Var)e.getKey(), (Concept)e.getValue()));
        }
        return unified.setExplanation(this.getExplanation());
    }

    public Stream<Answer> permute(Set<Unifier> unifierSet) {
        if (unifierSet.isEmpty()) {
            return Stream.of(this);
        }
        return unifierSet.stream().map(this::unify);
    }

    public AnswerExplanation getExplanation() {
        return this.explanation;
    }

    public QueryAnswer setExplanation(AnswerExplanation e) {
        this.explanation = e;
        return this;
    }

    public Set<Answer> getExplicitPath() {
        return this.getAnswers().stream().filter(ans -> ans.getExplanation().isLookupExplanation()).collect(Collectors.toSet());
    }

    public Set<Answer> getAnswers() {
        HashSet answers = Sets.newHashSet((Object[])new Answer[]{this});
        this.getExplanation().getAnswers().forEach((? super T ans) -> ans.getAnswers().forEach(answers::add));
        return answers;
    }

    public Set<AnswerExplanation> getExplanations() {
        HashSet explanations = Sets.newHashSet((Object[])new AnswerExplanation[]{this.getExplanation()});
        this.getExplanation().getAnswers().forEach((? super T ans) -> ans.getExplanations().forEach(explanations::add));
        return explanations;
    }

    private static /* synthetic */ void lambda$unify$3(Unifier unifier, Multimap answerMultimap, Map.Entry e) {
        Var var = (Var)e.getKey();
        Collection uvars = unifier.get(var);
        if (uvars.isEmpty()) {
            answerMultimap.put((Object)var, e.getValue());
        } else {
            uvars.forEach((? super T uv) -> answerMultimap.put(uv, e.getValue()));
        }
    }
}

