/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.NamedAggregate;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.aggregate.CountAggregate;
import ai.grakn.graql.internal.query.aggregate.GroupAggregate;
import ai.grakn.graql.internal.query.aggregate.ListAggregate;
import ai.grakn.graql.internal.query.aggregate.MaxAggregate;
import ai.grakn.graql.internal.query.aggregate.MeanAggregate;
import ai.grakn.graql.internal.query.aggregate.MedianAggregate;
import ai.grakn.graql.internal.query.aggregate.MinAggregate;
import ai.grakn.graql.internal.query.aggregate.SelectAggregate;
import ai.grakn.graql.internal.query.aggregate.StdAggregate;
import ai.grakn.graql.internal.query.aggregate.SumAggregate;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Aggregates {
    private Aggregates() {
    }

    public static Aggregate<Answer, Optional<Double>> mean(Var varName) {
        return new MeanAggregate(varName);
    }

    public static Aggregate<Object, Long> count() {
        return new CountAggregate();
    }

    public static Aggregate<Answer, Map<Concept, List<Answer>>> group(Var varName) {
        return Aggregates.group(varName, Aggregates.list());
    }

    public static <T> Aggregate<Answer, Map<Concept, T>> group(Var varName, Aggregate<? super Answer, T> innerAggregate) {
        return new GroupAggregate<T>(varName, innerAggregate);
    }

    public static <T> Aggregate<T, List<T>> list() {
        return new ListAggregate();
    }

    public static <T extends Comparable<T>> Aggregate<Answer, Optional<T>> max(Var varName) {
        return new MaxAggregate(varName);
    }

    public static Aggregate<Answer, Optional<Number>> median(Var varName) {
        return new MedianAggregate(varName);
    }

    public static Aggregate<Answer, Optional<Double>> std(Var varName) {
        return new StdAggregate(varName);
    }

    public static <T extends Comparable<T>> Aggregate<Answer, Optional<T>> min(Var varName) {
        return new MinAggregate(varName);
    }

    public static <S, T> Aggregate<S, Map<String, T>> select(ImmutableSet<NamedAggregate<? super S, ? extends T>> aggregates) {
        return new SelectAggregate<S, T>(aggregates);
    }

    public static Aggregate<Answer, Number> sum(Var varName) {
        return new SumAggregate(varName);
    }
}

