/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.aggregate.AbstractAggregate;
import ai.grakn.graql.internal.query.aggregate.ListAggregate;
import ai.grakn.util.ErrorMessage;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

class GroupAggregate<T>
extends AbstractAggregate<Answer, Map<Concept, T>> {
    private final Var varName;
    private final Aggregate<? super Answer, T> innerAggregate;

    GroupAggregate(Var varName, Aggregate<? super Answer, T> innerAggregate) {
        this.varName = varName;
        this.innerAggregate = innerAggregate;
    }

    public Map<Concept, T> apply(Stream<? extends Answer> stream) {
        Collector applyAggregate = Collectors.collectingAndThen(Collectors.toList(), list -> this.innerAggregate.apply(list.stream()));
        return stream.collect(Collectors.groupingBy(this::getConcept, applyAggregate));
    }

    @Nonnull
    private Concept getConcept(Answer result) {
        Concept concept = result.get(this.varName);
        if (concept == null) {
            throw new IllegalArgumentException(ErrorMessage.VARIABLE_NOT_IN_QUERY.getMessage(new Object[]{this.varName}));
        }
        return concept;
    }

    public String toString() {
        if (this.innerAggregate instanceof ListAggregate) {
            return "group " + this.varName;
        }
        return "group " + this.varName + " " + this.innerAggregate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupAggregate that = (GroupAggregate)o;
        if (!this.varName.equals((Object)that.varName)) {
            return false;
        }
        return this.innerAggregate.equals(that.innerAggregate);
    }

    public int hashCode() {
        int result = this.varName.hashCode();
        result = 31 * result + this.innerAggregate.hashCode();
        return result;
    }
}

