/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeId;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graph.admin.GraknAdmin;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractStatisticsQuery<T>
extends AbstractComputeQuery<T> {
    Set<TypeLabel> statisticsResourceTypeLabels = new HashSet<TypeLabel>();
    private final Map<TypeLabel, ResourceType.DataType> resourceTypesDataTypeMap = new HashMap<TypeLabel, ResourceType.DataType>();

    AbstractStatisticsQuery() {
    }

    AbstractStatisticsQuery<T> setStatisticsResourceType(String ... statisticsResourceTypeLabels) {
        this.statisticsResourceTypeLabels = Arrays.stream(statisticsResourceTypeLabels).map(TypeLabel::of).collect(Collectors.toSet());
        return this;
    }

    AbstractStatisticsQuery<T> setStatisticsResourceType(Collection<TypeLabel> statisticsResourceTypeLabels) {
        this.statisticsResourceTypeLabels = Sets.newHashSet(statisticsResourceTypeLabels);
        return this;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Override
    void initSubGraph() {
        super.initSubGraph();
        this.getResourceTypes((GraknGraph)this.graph.get());
    }

    @Override
    final String graqlString() {
        return this.getName() + this.resourcesString() + this.subtypeString();
    }

    abstract String getName();

    private String resourcesString() {
        return " of " + this.statisticsResourceTypeLabels.stream().map(StringConverter::typeLabelToString).collect(Collectors.joining(", "));
    }

    private void getResourceTypes(GraknGraph graph) {
        if (this.statisticsResourceTypeLabels.isEmpty()) {
            throw new IllegalStateException(ErrorMessage.RESOURCE_TYPE_NOT_SPECIFIED.getMessage(new Object[0]));
        }
        Set statisticsResourceTypes = this.statisticsResourceTypeLabels.stream().map(label -> {
            Type type = graph.getType(label);
            if (type == null) {
                throw new IllegalArgumentException(ErrorMessage.LABEL_NOT_FOUND.getMessage(new Object[]{label}));
            }
            return type;
        }).collect(Collectors.toSet());
        for (Type type2 : statisticsResourceTypes) {
            type2.subTypes().forEach(subtype -> this.statisticsResourceTypeLabels.add(subtype.getLabel()));
        }
        ResourceType metaResourceType = graph.admin().getMetaResourceType();
        metaResourceType.subTypes().stream().filter(type -> !type.equals(metaResourceType)).forEach(type -> this.resourceTypesDataTypeMap.put(type.asType().getLabel(), type.asResourceType().getDataType()));
    }

    ResourceType.DataType getDataTypeOfSelectedResourceTypes(Set<TypeLabel> resourceTypes) {
        if (resourceTypes == null || resourceTypes.isEmpty()) {
            throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{this.getClass().toString()}));
        }
        ResourceType.DataType dataType = null;
        for (TypeLabel resourceType : resourceTypes) {
            if (!this.resourceTypesDataTypeMap.containsKey(resourceType)) {
                throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{this.getClass().toString()}));
            }
            if (!(dataType == null ? !(dataType = this.resourceTypesDataTypeMap.get(resourceType)).equals(ResourceType.DataType.LONG) && !dataType.equals(ResourceType.DataType.DOUBLE) : !dataType.equals(this.resourceTypesDataTypeMap.get(resourceType)))) continue;
            throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{this.getClass().toString()}));
        }
        return dataType;
    }

    boolean selectedResourceTypesHaveInstance(Set<TypeLabel> statisticsResourceTypes) {
        List checkResourceTypes = statisticsResourceTypes.stream().map(type -> Graql.var("x").has(type, Graql.var())).collect(Collectors.toList());
        List checkSubtypes = this.subTypeLabels.stream().map(type -> Graql.var("x").isa(Graql.label(type))).collect(Collectors.toList());
        if (this.graph.isPresent()) {
            return (Boolean)((GraknGraph)this.graph.get()).graql().infer(false).match(new Pattern[]{Graql.or(checkResourceTypes), Graql.or(checkSubtypes)}).ask().execute();
        }
        throw new RuntimeException("Cannot compute the instnces of a type without a graph");
    }

    Set<TypeLabel> getCombinedSubTypes() {
        Set<TypeLabel> allSubTypes = this.statisticsResourceTypeLabels.stream().map(arg_0 -> ((Schema.ImplicitType)Schema.ImplicitType.HAS).getLabel(arg_0)).collect(Collectors.toSet());
        allSubTypes.addAll(this.subTypeLabels);
        allSubTypes.addAll(this.statisticsResourceTypeLabels);
        return allSubTypes;
    }

    Set<TypeId> convertLabelsToIds(Set<TypeLabel> labelSet) {
        return labelSet.stream().map(arg_0 -> ((GraknAdmin)((GraknGraph)this.graph.get()).admin()).convertToId(arg_0)).collect(Collectors.toSet());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractStatisticsQuery that = (AbstractStatisticsQuery)o;
        return this.statisticsResourceTypeLabels.equals(that.statisticsResourceTypeLabels) && this.resourceTypesDataTypeMap.equals(that.resourceTypesDataTypeMap);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.statisticsResourceTypeLabels.hashCode();
        result = 31 * result + this.resourceTypesDataTypeMap.hashCode();
        return result;
    }
}

