/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.TypeId;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graph.admin.GraknAdmin;
import ai.grakn.graql.analytics.ClusterQuery;
import ai.grakn.graql.internal.analytics.ClusterMemberMapReduce;
import ai.grakn.graql.internal.analytics.ClusterSizeMapReduce;
import ai.grakn.graql.internal.analytics.ConnectedComponentVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class ClusterQueryImpl<T>
extends AbstractComputeQuery<T>
implements ClusterQuery<T> {
    private boolean members = false;
    private boolean anySize = true;
    private long clusterSize = -1L;

    ClusterQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public T execute() {
        LOGGER.info("ConnectedComponentsVertexProgram is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        if (!this.selectedTypesHaveInstance()) {
            return (T)Collections.emptyMap();
        }
        Set<TypeLabel> withResourceRelationTypes = this.getHasResourceRelationTypes();
        withResourceRelationTypes.addAll(this.subTypeLabels);
        String randomId = ClusterQueryImpl.getRandomJobId();
        Set<TypeId> withResourceRelationTypeIds = withResourceRelationTypes.stream().map(arg_0 -> ((GraknAdmin)((GraknGraph)this.graph.get()).admin()).convertToId(arg_0)).collect(Collectors.toSet());
        Set<TypeId> subTypeIds = this.subTypeLabels.stream().map(arg_0 -> ((GraknAdmin)((GraknGraph)this.graph.get()).admin()).convertToId(arg_0)).collect(Collectors.toSet());
        if (this.members) {
            ComputerResult result = this.anySize ? this.getGraphComputer().compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypeIds, randomId), new MapReduce[]{new ClusterMemberMapReduce(subTypeIds, "connectedComponentVertexProgram.clusterLabel" + randomId)}) : this.getGraphComputer().compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypeIds, randomId), new MapReduce[]{new ClusterMemberMapReduce(subTypeIds, "connectedComponentVertexProgram.clusterLabel" + randomId, this.clusterSize)});
            LOGGER.info("ConnectedComponentsVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
            return (T)result.memory().get(ClusterMemberMapReduce.class.getName());
        }
        ComputerResult result = this.anySize ? this.getGraphComputer().compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypeIds, randomId), new MapReduce[]{new ClusterSizeMapReduce(subTypeIds, "connectedComponentVertexProgram.clusterLabel" + randomId)}) : this.getGraphComputer().compute((VertexProgram)new ConnectedComponentVertexProgram(withResourceRelationTypeIds, randomId), new MapReduce[]{new ClusterSizeMapReduce(subTypeIds, "connectedComponentVertexProgram.clusterLabel" + randomId, this.clusterSize)});
        LOGGER.info("ConnectedComponentsVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return (T)result.memory().get(ClusterSizeMapReduce.class.getName());
    }

    public boolean isReadOnly() {
        return true;
    }

    public ClusterQuery<Map<String, Set<String>>> members() {
        this.members = true;
        return this;
    }

    public ClusterQuery<T> clusterSize(long clusterSize) {
        this.anySize = false;
        this.clusterSize = clusterSize;
        return this;
    }

    @Override
    public ClusterQuery<T> in(String ... subTypeLabels) {
        return (ClusterQuery)super.in(subTypeLabels);
    }

    @Override
    public ClusterQuery<T> in(Collection<TypeLabel> subTypeLabels) {
        return (ClusterQuery)super.in(subTypeLabels);
    }

    @Override
    String graqlString() {
        String string = "cluster" + this.subtypeString();
        if (this.members) {
            string = string + " members;";
        }
        if (!this.anySize) {
            string = string + " size " + this.clusterSize + ";";
        }
        return string;
    }

    @Override
    public ClusterQuery<T> withGraph(GraknGraph graph) {
        return (ClusterQuery)super.withGraph(graph);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterQueryImpl that = (ClusterQueryImpl)o;
        if (this.members != that.members) {
            return false;
        }
        if (this.anySize != that.anySize) {
            return false;
        }
        return this.clusterSize == that.clusterSize;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.members ? 1 : 0);
        result = 31 * result + (this.anySize ? 1 : 0);
        result = 31 * result + (int)(this.clusterSize ^ this.clusterSize >>> 32);
        return result;
    }
}

