/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graph.admin.GraknAdmin;
import ai.grakn.graql.analytics.CountQuery;
import ai.grakn.graql.internal.analytics.CountMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;

class CountQueryImpl
extends AbstractComputeQuery<Long>
implements CountQuery {
    CountQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Long execute() {
        LOGGER.info("CountMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        if (!this.selectedTypesHaveInstance()) {
            LOGGER.debug("Count = 0");
            LOGGER.info("CountMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
            return 0L;
        }
        ComputerResult result = this.getGraphComputer().compute((MapReduce)new CountMapReduce(this.subTypeLabels.stream().map(arg_0 -> ((GraknAdmin)((GraknGraph)this.graph.get()).admin()).convertToId(arg_0)).collect(Collectors.toSet())));
        Map count = (Map)result.memory().get(CountMapReduce.class.getName());
        LOGGER.debug("Count = " + count.get(MapReduce.NullObject.instance()));
        LOGGER.info("CountMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return (Long)count.get(MapReduce.NullObject.instance());
    }

    public boolean isReadOnly() {
        return true;
    }

    public CountQuery in(String ... subTypeLabels) {
        return (CountQuery)super.in(subTypeLabels);
    }

    public CountQuery in(Collection<TypeLabel> subTypeLabels) {
        return (CountQuery)super.in(subTypeLabels);
    }

    @Override
    String graqlString() {
        return "count" + this.subtypeString();
    }

    public CountQuery withGraph(GraknGraph graph) {
        return (CountQuery)super.withGraph(graph);
    }
}

