/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.TypeId;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graph.admin.GraknAdmin;
import ai.grakn.graql.analytics.DegreeQuery;
import ai.grakn.graql.internal.analytics.DegreeDistributionMapReduce;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class DegreeQueryImpl
extends AbstractComputeQuery<Map<Long, Set<String>>>
implements DegreeQuery {
    private boolean ofTypeLabelsSet = false;
    private Set<TypeLabel> ofTypeLabels = new HashSet<TypeLabel>();

    DegreeQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Map<Long, Set<String>> execute() {
        LOGGER.info("DegreeVertexProgram is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        if (!this.selectedTypesHaveInstance()) {
            return Collections.emptyMap();
        }
        this.ofTypeLabels.forEach(type -> {
            if (!this.subTypeLabels.contains(type)) {
                throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{type}));
            }
        });
        Set<TypeLabel> withResourceRelationTypes = this.getHasResourceRelationTypes();
        withResourceRelationTypes.addAll(this.subTypeLabels);
        if (this.ofTypeLabels.isEmpty()) {
            this.ofTypeLabels.addAll(this.subTypeLabels);
        }
        Set<TypeId> withResourceRelationTypeIds = withResourceRelationTypes.stream().map(arg_0 -> ((GraknAdmin)((GraknGraph)this.graph.get()).admin()).convertToId(arg_0)).collect(Collectors.toSet());
        Set<TypeId> ofTypeIds = this.ofTypeLabels.stream().map(arg_0 -> ((GraknAdmin)((GraknGraph)this.graph.get()).admin()).convertToId(arg_0)).collect(Collectors.toSet());
        String randomId = DegreeQueryImpl.getRandomJobId();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeVertexProgram(withResourceRelationTypeIds, ofTypeIds, randomId), new MapReduce[]{new DegreeDistributionMapReduce(ofTypeIds, "degreeVertexProgram.degree" + randomId)});
        LOGGER.info("DegreeVertexProgram is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return (Map)result.memory().get(DegreeDistributionMapReduce.class.getName());
    }

    public boolean isReadOnly() {
        return true;
    }

    public DegreeQuery in(String ... subTypeLabels) {
        return (DegreeQuery)super.in(subTypeLabels);
    }

    public DegreeQuery in(Collection<TypeLabel> subTypeLabels) {
        return (DegreeQuery)super.in(subTypeLabels);
    }

    public DegreeQuery of(String ... ofTypeLabels) {
        if (ofTypeLabels.length > 0) {
            this.ofTypeLabelsSet = true;
            this.ofTypeLabels = Arrays.stream(ofTypeLabels).map(TypeLabel::of).collect(Collectors.toSet());
        }
        return this;
    }

    public DegreeQuery of(Collection<TypeLabel> ofTypeLabels) {
        if (!ofTypeLabels.isEmpty()) {
            this.ofTypeLabelsSet = true;
            this.ofTypeLabels = Sets.newHashSet(ofTypeLabels);
        }
        return this;
    }

    @Override
    String graqlString() {
        String string = "degrees";
        if (this.ofTypeLabelsSet) {
            string = string + " of " + this.ofTypeLabels.stream().map(StringConverter::typeLabelToString).collect(Collectors.joining(", "));
        }
        string = string + this.subtypeString();
        return string;
    }

    public DegreeQuery withGraph(GraknGraph graph) {
        return (DegreeQuery)super.withGraph(graph);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DegreeQueryImpl that = (DegreeQueryImpl)o;
        if (this.ofTypeLabelsSet != that.ofTypeLabelsSet) {
            return false;
        }
        return this.ofTypeLabels.equals(that.ofTypeLabels);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ofTypeLabelsSet ? 1 : 0);
        result = 31 * result + this.ofTypeLabels.hashCode();
        return result;
    }
}

