/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeId;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.analytics.MeanQuery;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.MeanMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MeanQueryImpl
extends AbstractStatisticsQuery<Optional<Double>>
implements MeanQuery {
    MeanQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Double> execute() {
        LOGGER.info("MeanMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        ResourceType.DataType dataType = this.getDataTypeOfSelectedResourceTypes(this.statisticsResourceTypeLabels);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeLabels)) {
            return Optional.empty();
        }
        Set<TypeId> allSubTypeIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<TypeId> statisticsResourceTypeIds = this.convertLabelsToIds(this.statisticsResourceTypeLabels);
        String randomId = MeanQueryImpl.getRandomJobId();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeStatisticsVertexProgram(allSubTypeIds, statisticsResourceTypeIds, randomId), new MapReduce[]{new MeanMapReduce(statisticsResourceTypeIds, dataType, "degreeVertexProgram.degree" + randomId)});
        Map mean = (Map)result.memory().get(MeanMapReduce.class.getName());
        Map meanPair = (Map)mean.get(MapReduce.NullObject.instance());
        double finalResult = (Double)meanPair.get("S") / (Double)meanPair.get("C");
        LOGGER.debug("Mean = " + finalResult);
        LOGGER.info("MeanMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(finalResult);
    }

    public MeanQuery of(String ... resourceTypeLabels) {
        return (MeanQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MeanQuery of(Collection<TypeLabel> resourceTypeLabels) {
        return (MeanQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public MeanQuery in(String ... subTypeLabels) {
        return (MeanQuery)super.in(subTypeLabels);
    }

    public MeanQuery in(Collection<TypeLabel> subTypeLabels) {
        return (MeanQuery)super.in(subTypeLabels);
    }

    public MeanQuery withGraph(GraknGraph graph) {
        return (MeanQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "mean";
    }
}

