/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.TypeId;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.analytics.SumQuery;
import ai.grakn.graql.internal.analytics.DegreeStatisticsVertexProgram;
import ai.grakn.graql.internal.analytics.SumMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class SumQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements SumQuery {
    SumQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("SumMapReduce is called");
        long startTime = System.currentTimeMillis();
        this.initSubGraph();
        ResourceType.DataType dataType = this.getDataTypeOfSelectedResourceTypes(this.statisticsResourceTypeLabels);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeLabels)) {
            return Optional.empty();
        }
        Set<TypeId> allSubTypeIds = this.convertLabelsToIds(this.getCombinedSubTypes());
        Set<TypeId> statisticsResourceTypeIds = this.convertLabelsToIds(this.statisticsResourceTypeLabels);
        String randomId = SumQueryImpl.getRandomJobId();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeStatisticsVertexProgram(allSubTypeIds, statisticsResourceTypeIds, randomId), new MapReduce[]{new SumMapReduce(statisticsResourceTypeIds, dataType, "degreeVertexProgram.degree" + randomId)});
        Map sum = (Map)result.memory().get(SumMapReduce.class.getName());
        Number finalResult = (Number)sum.get(MapReduce.NullObject.instance());
        LOGGER.info("Sum = " + finalResult);
        LOGGER.info("SumMapReduce is done in " + (System.currentTimeMillis() - startTime) + " ms");
        return Optional.of(finalResult);
    }

    public SumQuery of(String ... resourceTypeLabels) {
        return (SumQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public SumQuery of(Collection<TypeLabel> resourceTypeLabels) {
        return (SumQuery)this.setStatisticsResourceType(resourceTypeLabels);
    }

    public SumQuery in(String ... subTypeLabels) {
        return (SumQuery)super.in(subTypeLabels);
    }

    public SumQuery in(Collection<TypeLabel> subTypeLabels) {
        return (SumQuery)super.in(subTypeLabels);
    }

    public SumQuery withGraph(GraknGraph graph) {
        return (SumQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "sum";
    }
}

