/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.AggregateQuery;
import ai.grakn.graql.AskQuery;
import ai.grakn.graql.DeleteQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Order;
import ai.grakn.graql.Printer;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.MatchQueryAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.query.Queries;
import ai.grakn.graql.internal.query.match.MatchOrderImpl;
import ai.grakn.graql.internal.query.match.MatchQueryDistinct;
import ai.grakn.graql.internal.query.match.MatchQueryGraph;
import ai.grakn.graql.internal.query.match.MatchQueryLimit;
import ai.grakn.graql.internal.query.match.MatchQueryOffset;
import ai.grakn.graql.internal.query.match.MatchQueryOrder;
import ai.grakn.graql.internal.query.match.MatchQuerySelect;
import ai.grakn.graql.internal.util.AdminConverter;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AbstractMatchQuery
implements MatchQueryAdmin {
    AbstractMatchQuery() {
    }

    public final Stream<String> resultsString(Printer printer) {
        return this.stream().map(arg_0 -> ((Printer)printer).graqlString(arg_0));
    }

    public final boolean isReadOnly() {
        return true;
    }

    public final MatchQueryAdmin admin() {
        return this;
    }

    public final List<Answer> execute() {
        return this.stream().collect(Collectors.toList());
    }

    public abstract Stream<Answer> stream(Optional<GraknGraph> var1);

    public final Stream<Answer> stream() {
        return this.stream(Optional.empty());
    }

    public final MatchQuery withGraph(GraknGraph graph) {
        return new MatchQueryGraph(graph, this);
    }

    public final MatchQuery limit(long limit) {
        return new MatchQueryLimit(this, limit);
    }

    public final MatchQuery offset(long offset) {
        return new MatchQueryOffset(this, offset);
    }

    public final MatchQuery distinct() {
        return new MatchQueryDistinct(this);
    }

    public final <S> AggregateQuery<S> aggregate(Aggregate<? super Answer, S> aggregate) {
        return Queries.aggregate(this.admin(), aggregate);
    }

    public final MatchQuery select(String ... names) {
        return this.select(Stream.of(names).map(Var::of).collect(Collectors.toSet()));
    }

    public final MatchQuery select(Set<Var> names) {
        return new MatchQuerySelect(this, (ImmutableSet<Var>)ImmutableSet.copyOf(names));
    }

    public final Stream<Concept> get(String name) {
        Var var = Var.of((String)name);
        return this.stream().map(result -> {
            if (!result.containsKey(var)) {
                throw new IllegalArgumentException(ErrorMessage.VARIABLE_NOT_IN_QUERY.getMessage(new Object[]{Var.of((String)name)}));
            }
            return result.get(var);
        });
    }

    public final AskQuery ask() {
        return Queries.ask((MatchQuery)this);
    }

    public final InsertQuery insert(VarPattern ... vars) {
        return this.insert(Arrays.asList(vars));
    }

    public final InsertQuery insert(Collection<? extends VarPattern> vars) {
        ImmutableMultiset varAdmins = ImmutableMultiset.copyOf(AdminConverter.getVarAdmins(vars));
        return Queries.insert((ImmutableCollection<VarPatternAdmin>)varAdmins, this.admin());
    }

    public final DeleteQuery delete(VarPattern ... deleters) {
        return this.delete(Arrays.asList(deleters));
    }

    public final DeleteQuery delete(String ... names) {
        List deleters = Arrays.stream(names).map(Graql::var).collect(Collectors.toList());
        return this.delete(deleters);
    }

    public final DeleteQuery delete(Collection<? extends VarPattern> deleters) {
        return Queries.delete(AdminConverter.getVarAdmins(deleters), (MatchQuery)this);
    }

    public final MatchQuery orderBy(String varName) {
        return this.orderBy(varName, Order.asc);
    }

    public final MatchQuery orderBy(Var varName) {
        return this.orderBy(varName, Order.asc);
    }

    public final MatchQuery orderBy(String varName, Order order) {
        return this.orderBy(Var.of((String)varName), order);
    }

    public final MatchQuery orderBy(Var varName, Order order) {
        return new MatchQueryOrder(this, new MatchOrderImpl(varName, order));
    }
}

