/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.GraknGraph;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.match.AbstractMatchQuery;
import ai.grakn.graql.internal.query.match.MatchQueryModifier;
import ai.grakn.util.ErrorMessage;
import java.util.Optional;
import java.util.stream.Stream;

class MatchQueryLimit
extends MatchQueryModifier {
    private final long limit;

    MatchQueryLimit(AbstractMatchQuery inner, long limit) {
        super(inner);
        if (limit <= 0L) {
            throw new IllegalArgumentException(ErrorMessage.NON_POSITIVE_LIMIT.getMessage(new Object[]{limit}));
        }
        this.limit = limit;
    }

    @Override
    public Stream<Answer> stream(Optional<GraknGraph> graph) {
        return this.inner.stream(graph).limit(this.limit);
    }

    @Override
    protected String modifierString() {
        return " limit " + this.limit + ";";
    }
}

