/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.GraknGraph;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.match.AbstractMatchQuery;
import ai.grakn.graql.internal.query.match.MatchQueryModifier;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MatchQuerySelect
extends MatchQueryModifier {
    private final ImmutableSet<Var> names;

    MatchQuerySelect(AbstractMatchQuery inner, ImmutableSet<Var> names) {
        super(inner);
        Set selectedNames = inner.getSelectedNames();
        for (Var name : names) {
            if (selectedNames.contains(name)) continue;
            throw new IllegalArgumentException(ErrorMessage.VARIABLE_NOT_IN_QUERY.getMessage(new Object[]{name}));
        }
        if (names.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessage.SELECT_NONE_SELECTED.getMessage(new Object[0]));
        }
        this.names = names;
    }

    @Override
    public Stream<Answer> stream(Optional<GraknGraph> graph) {
        return this.inner.stream(graph).map(result -> result.filterVars(this.names));
    }

    @Override
    protected String modifierString() {
        return " select " + this.names.stream().map(Object::toString).collect(Collectors.joining(", ")) + ";";
    }

    @Override
    public Set<Var> getSelectedNames() {
        return this.names;
    }
}

