/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.NeqPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Atom
extends AtomicBase {
    private Type type = null;
    protected ConceptId typeId = null;
    private int basePriority = Integer.MAX_VALUE;
    protected Set<InferenceRule> applicableRules = null;

    protected Atom(VarPatternAdmin pattern, ReasonerQuery par) {
        super(pattern, par);
    }

    protected Atom(Atom a) {
        super(a);
        this.type = a.type;
        this.typeId = a.typeId;
        this.applicableRules = a.applicableRules;
    }

    public boolean isAtom() {
        return true;
    }

    public boolean isType() {
        return false;
    }

    public boolean isRelation() {
        return false;
    }

    public boolean isResource() {
        return false;
    }

    public Set<IdPredicate> getPartialSubstitutions() {
        return new HashSet<IdPredicate>();
    }

    public int computePriority() {
        return this.computePriority(this.getPartialSubstitutions().stream().map(AtomicBase::getVarName).collect(Collectors.toSet()));
    }

    public int computePriority(Set<Var> subbedVars) {
        int priority = 0;
        priority += Sets.intersection(this.getVarNames(), subbedVars).size() * 30;
        priority += this.isRuleResolvable() ? -10 : 0;
        priority += this.isRecursive() ? -5 : 0;
        priority += this.getTypeConstraints().size() * 1;
        Set otherVars = this.getParentQuery().getAtoms().stream().filter(a -> a != this).flatMap(at -> at.getVarNames().stream()).collect(Collectors.toSet());
        priority += Sets.intersection(this.getVarNames(), otherVars).size() * -2;
        priority = (int)((long)priority + this.getPredicates().stream().filter(Predicate::isNeqPredicate).map(p -> (NeqPredicate)p).map(Predicate::getPredicate).filter(v -> !subbedVars.contains(v)).count() * -1000L);
        return priority;
    }

    public int baseResolutionPriority() {
        if (this.basePriority == Integer.MAX_VALUE) {
            this.basePriority = this.computePriority();
        }
        return this.basePriority;
    }

    public abstract boolean isRuleApplicable(InferenceRule var1);

    private Set<Rule> getPotentialRules() {
        Type type = this.getType();
        return type != null ? type.subTypes().stream().flatMap(t -> t.getRulesOfConclusion().stream()).collect(Collectors.toSet()) : ReasonerUtils.getRules(this.graph());
    }

    public Set<InferenceRule> getApplicableRules() {
        if (this.applicableRules == null) {
            this.applicableRules = this.getPotentialRules().stream().map(rule -> new InferenceRule((Rule)rule, this.graph())).filter(this::isRuleApplicable).collect(Collectors.toSet());
        }
        return this.applicableRules;
    }

    public boolean isRuleResolvable() {
        return !this.getApplicableRules().isEmpty();
    }

    public boolean isRecursive() {
        if (this.isResource() || this.getType() == null) {
            return false;
        }
        Type type = this.getType();
        return this.getApplicableRules().stream().filter(rule -> rule.getBody().selectAtoms().stream().filter(at -> Objects.nonNull(at.getType())).filter(at -> ReasonerUtils.checkTypesCompatible(type, at.getType())).findFirst().isPresent()).filter(this::isRuleApplicable).findFirst().isPresent();
    }

    public boolean isAllowedToFormRuleHead() {
        return false;
    }

    public boolean requiresMaterialisation() {
        return false;
    }

    public Type getType() {
        if (this.type == null && this.typeId != null) {
            this.type = this.getParentQuery().graph().getConcept(this.typeId).asType();
        }
        return this.type;
    }

    public ConceptId getTypeId() {
        return this.typeId;
    }

    public Var getValueVariable() {
        throw new IllegalArgumentException("getValueVariable called on Atom object " + this.getPattern());
    }

    public Set<Predicate> getPredicates() {
        return ((ReasonerQueryImpl)this.getParentQuery()).getPredicates().stream().filter(atom -> this.containsVar(atom.getVarName())).collect(Collectors.toSet());
    }

    public Set<IdPredicate> getIdPredicates() {
        return ((ReasonerQueryImpl)this.getParentQuery()).getIdPredicates().stream().filter(atom -> this.containsVar(atom.getVarName())).collect(Collectors.toSet());
    }

    public Set<ValuePredicate> getValuePredicates() {
        return ((ReasonerQueryImpl)this.getParentQuery()).getValuePredicates().stream().filter(atom -> atom.getVarName().equals((Object)this.getValueVariable())).collect(Collectors.toSet());
    }

    public Set<TypeAtom> getTypeConstraints() {
        HashSet<TypeAtom> relevantTypes = new HashSet<TypeAtom>();
        ((ReasonerQueryImpl)this.getParentQuery()).getTypeConstraints().stream().filter(atom -> atom != this).filter(atom -> this.containsVar(atom.getVarName())).forEach(relevantTypes::add);
        return relevantTypes;
    }

    public Stream<Atom> getNeighbours() {
        return this.getParentQuery().getAtoms().stream().filter(Atomic::isAtom).map(at -> (Atom)at).filter(at -> at != this).filter(at -> !Sets.intersection(this.getVarNames(), at.getVarNames()).isEmpty());
    }

    public Set<Atomic> getNonSelectableConstraints() {
        Set types = this.getTypeConstraints().stream().filter(at -> !at.isSelectable()).collect(Collectors.toSet());
        return Sets.union(types, this.getPredicates());
    }

    public Set<IdPredicate> getUnmappedIdPredicates() {
        return new HashSet<IdPredicate>();
    }

    public Set<TypeAtom> getUnmappedTypeConstraints() {
        return new HashSet<TypeAtom>();
    }

    public Set<TypeAtom> getMappedTypeConstraints() {
        return new HashSet<TypeAtom>();
    }

    public Set<Unifier> getPermutationUnifiers(Atom headAtom) {
        return new HashSet<Unifier>();
    }

    public void inferTypes() {
    }

    public Atom rewriteToUserDefined() {
        return this;
    }

    public abstract Unifier getUnifier(Atom var1);
}

