/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.concept.ConceptId;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.BinaryBase;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import com.google.common.collect.Sets;
import java.util.HashSet;

public abstract class Binary
extends BinaryBase {
    private IdPredicate predicate = null;

    Binary(VarPatternAdmin pattern, IdPredicate p, ReasonerQuery par) {
        super(pattern, par);
        this.predicate = p;
        this.typeId = this.extractTypeId();
    }

    Binary(Binary a) {
        super(a);
        this.predicate = a.getPredicate() != null ? (IdPredicate)AtomicFactory.create(a.getPredicate(), this.getParentQuery()) : null;
    }

    protected abstract ConceptId extractTypeId();

    @Override
    public PatternAdmin getCombinedPattern() {
        HashSet vars = Sets.newHashSet((Object[])new VarPatternAdmin[]{super.getPattern().asVar()});
        if (this.getPredicate() != null) {
            vars.add(this.getPredicate().getPattern().asVar());
        }
        return Patterns.conjunction(vars);
    }

    @Override
    public void setParentQuery(ReasonerQuery q) {
        super.setParentQuery(q);
        if (this.predicate != null) {
            this.predicate.setParentQuery(q);
        }
    }

    public IdPredicate getPredicate() {
        return this.predicate;
    }

    void setPredicate(IdPredicate p) {
        this.predicate = p;
    }

    @Override
    protected boolean hasEquivalentPredicatesWith(BinaryBase atom) {
        IdPredicate pred = this.getPredicate();
        IdPredicate objPredicate = ((Binary)atom).getPredicate();
        return pred == null && objPredicate == null || pred != null && pred.isEquivalent(objPredicate);
    }

    public int equivalenceHashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
        hashCode = hashCode * 37 + (this.predicate != null ? this.predicate.equivalenceHashCode() : 0);
        return hashCode;
    }
}

