/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.util.ErrorMessage;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class BinaryBase
extends Atom {
    private Var valueVariable;

    BinaryBase(VarPatternAdmin pattern, ReasonerQuery par) {
        super(pattern, par);
        this.valueVariable = this.extractValueVariableName(pattern);
    }

    BinaryBase(BinaryBase a) {
        super(a);
        this.valueVariable = a.getValueVariable();
    }

    protected abstract Var extractValueVariableName(VarPatternAdmin var1);

    protected abstract boolean hasEquivalentPredicatesWith(BinaryBase var1);

    @Override
    public Var getValueVariable() {
        return this.valueVariable;
    }

    void setValueVariable(Var var) {
        this.valueVariable = var;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
        hashCode = hashCode * 37 + this.getVarName().hashCode();
        hashCode = hashCode * 37 + this.valueVariable.hashCode();
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BinaryBase a2 = (BinaryBase)obj;
        return Objects.equals(this.getTypeId(), a2.getTypeId()) && this.getVarName().equals((Object)a2.getVarName()) && this.valueVariable.equals((Object)a2.getValueVariable());
    }

    public boolean isEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BinaryBase a2 = (BinaryBase)obj;
        return Objects.equals(this.getTypeId(), a2.getTypeId()) && this.hasEquivalentPredicatesWith(a2);
    }

    @Override
    public Set<Var> getVarNames() {
        HashSet<Var> vars = new HashSet<Var>();
        if (this.isUserDefinedName()) {
            vars.add(this.getVarName());
        }
        if (!this.valueVariable.getValue().isEmpty()) {
            vars.add(this.valueVariable);
        }
        return vars;
    }

    @Override
    public Unifier getUnifier(Atom parentAtom) {
        Var parentVarName;
        Var childVarName;
        if (!(parentAtom instanceof BinaryBase)) {
            throw new IllegalArgumentException(ErrorMessage.UNIFICATION_ATOM_INCOMPATIBILITY.getMessage(new Object[0]));
        }
        UnifierImpl unifier = new UnifierImpl();
        Var childValVarName = this.getValueVariable();
        Var parentValVarName = parentAtom.getValueVariable();
        if (parentAtom.isUserDefinedName() && !(childVarName = this.getVarName()).equals((Object)(parentVarName = parentAtom.getVarName()))) {
            unifier.addMapping(childVarName, parentVarName);
        }
        if (!(childValVarName.getValue().isEmpty() || parentValVarName.getValue().isEmpty() || childValVarName.equals((Object)parentValVarName))) {
            unifier.addMapping(childValVarName, parentValVarName);
        }
        return unifier;
    }
}

