/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Type;
import ai.grakn.concept.TypeLabel;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.RelationProperty;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.graql.internal.reasoner.utils.conversion.RoleTypeConverter;
import ai.grakn.graql.internal.reasoner.utils.conversion.TypeConverterImpl;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.Schema;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class Relation
extends TypeAtom {
    private int hashCode = 0;
    private Multimap<RoleType, Var> roleVarMap = null;
    private Multimap<RoleType, String> roleConceptIdMap = null;
    private Set<RelationPlayer> relationPlayers = null;

    public Relation(VarPatternAdmin pattern, IdPredicate predicate, ReasonerQuery par) {
        super(pattern, predicate, par);
    }

    public Relation(Var name, Var typeVariable, Map<Var, VarPattern> roleMap, IdPredicate pred, ReasonerQuery par) {
        super(Relation.constructRelationVar(name, typeVariable, roleMap), pred, par);
    }

    private Relation(Relation a) {
        super(a);
        this.relationPlayers = a.relationPlayers;
        this.roleVarMap = a.roleVarMap;
    }

    @Override
    public String toString() {
        String relationString = (this.isUserDefinedName() ? this.getVarName() + " " : "") + (this.getType() != null ? this.getType().getLabel() : "") + this.getRelationPlayers().toString();
        return relationString + this.getIdPredicates().stream().map(IdPredicate::toString).collect(Collectors.joining(""));
    }

    private Set<RelationPlayer> getRelationPlayers() {
        if (this.relationPlayers == null) {
            this.relationPlayers = new HashSet<RelationPlayer>();
            this.atomPattern.asVar().getProperty(RelationProperty.class).ifPresent(prop -> prop.getRelationPlayers().forEach(this.relationPlayers::add));
        }
        return this.relationPlayers;
    }

    @Override
    protected Var extractValueVariableName(VarPatternAdmin var) {
        IsaProperty isaProp = var.getProperty(IsaProperty.class).orElse(null);
        return isaProp != null ? isaProp.getType().getVarName() : Var.of((String)"");
    }

    @Override
    protected void setValueVariable(Var var) {
        IsaProperty isaProp = this.atomPattern.asVar().getProperty(IsaProperty.class).orElse(null);
        if (isaProp != null) {
            super.setValueVariable(var);
            this.atomPattern = this.atomPattern.asVar().mapProperty(IsaProperty.class, prop -> new IsaProperty(prop.getType().setVarName(var)));
        }
    }

    @Override
    public Atomic copy() {
        return new Relation(this);
    }

    private static VarPatternAdmin constructRelationVar(Var varName, Var typeVariable, Map<Var, VarPattern> roleMap) {
        return Relation.constructRelationVar(varName, typeVariable, roleMap.entrySet().stream().map(e -> new Pair(e.getKey(), e.getValue())).collect(Collectors.toList()));
    }

    private static VarPatternAdmin constructRelationVar(Var varName, Var typeVariable, List<Pair<Var, VarPattern>> rolePlayerMappings) {
        VarPattern var = !varName.getValue().isEmpty() ? Graql.var(varName) : Graql.var();
        for (Pair<Var, VarPattern> mapping : rolePlayerMappings) {
            Var rp = (Var)mapping.getKey();
            VarPattern role = (VarPattern)mapping.getValue();
            var = role == null ? var.rel(Graql.var(rp)) : var.rel(role, Graql.var(rp));
        }
        var = var.isa(Graql.var(typeVariable));
        return var.admin().asVar();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Relation a2 = (Relation)obj;
        return Objects.equals(this.getTypeId(), a2.getTypeId()) && this.getVarNames().equals(a2.getVarNames()) && this.getRelationPlayers().equals(a2.getRelationPlayers());
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
            this.hashCode = this.hashCode * 37 + this.getVarNames().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public boolean isEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Relation a2 = (Relation)obj;
        return this.isUserDefinedName() == a2.isUserDefinedName() && Objects.equals(this.getTypeId(), a2.getTypeId()) && this.getRoleConceptIdMap().equals(a2.getRoleConceptIdMap()) && this.getRoleTypeMap().equals(a2.getRoleTypeMap()) && this.getRolePlayers().size() == a2.getRolePlayers().size();
    }

    @Override
    public int equivalenceHashCode() {
        int equivalenceHashCode = 1;
        equivalenceHashCode = equivalenceHashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
        equivalenceHashCode = equivalenceHashCode * 37 + this.getRoleConceptIdMap().hashCode();
        equivalenceHashCode = equivalenceHashCode * 37 + this.getRoleTypeMap().hashCode();
        return equivalenceHashCode;
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean isType() {
        return this.getType() != null;
    }

    @Override
    public boolean requiresMaterialisation() {
        return this.isUserDefinedName();
    }

    @Override
    public boolean isAllowedToFormRuleHead() {
        return super.isAllowedToFormRuleHead() && !this.hasMetaRoles();
    }

    @Override
    public int computePriority(Set<Var> subbedVars) {
        int priority = super.computePriority(subbedVars);
        return priority += 2;
    }

    @Override
    public Set<IdPredicate> getPartialSubstitutions() {
        Set<Var> rolePlayers = this.getRolePlayers();
        return this.getIdPredicates().stream().filter(pred -> rolePlayers.contains(pred.getVarName())).collect(Collectors.toSet());
    }

    private Multimap<RoleType, String> getRoleConceptIdMap() {
        if (this.roleConceptIdMap == null) {
            this.roleConceptIdMap = ArrayListMultimap.create();
            Map<Var, IdPredicate> varSubMap = this.getPartialSubstitutions().stream().collect(Collectors.toMap(Atomic::getVarName, pred -> pred));
            Multimap<RoleType, Var> roleMap = this.getRoleVarMap();
            roleMap.entries().forEach(e -> {
                RoleType role = (RoleType)e.getKey();
                Var var = (Var)e.getValue();
                this.roleConceptIdMap.put((Object)role, (Object)(varSubMap.containsKey(var) ? ((IdPredicate)varSubMap.get(var)).getPredicateValue() : ""));
            });
        }
        return this.roleConceptIdMap;
    }

    private Multimap<RoleType, Type> getRoleTypeMap() {
        ArrayListMultimap roleTypeMap = ArrayListMultimap.create();
        Multimap<RoleType, Var> roleMap = this.getRoleVarMap();
        Map varTypeMap = this.getParentQuery().getVarTypeMap();
        roleMap.entries().stream().filter(e -> varTypeMap.containsKey(e.getValue())).forEach(arg_0 -> Relation.lambda$getRoleTypeMap$7((Multimap)roleTypeMap, varTypeMap, arg_0));
        return roleTypeMap;
    }

    private boolean isRuleApplicableViaAtom(Relation headAtom) {
        return headAtom.getRelationPlayers().size() >= this.getRelationPlayers().size() && headAtom.getRelationPlayerMappings(this).size() == this.getRelationPlayers().size();
    }

    @Override
    public boolean isRuleApplicable(InferenceRule child) {
        Atom ruleAtom = child.getRuleConclusionAtom();
        if (!ruleAtom.isRelation()) {
            return false;
        }
        Relation headAtom = (Relation)ruleAtom;
        Type type = this.getType();
        Relation atomWithType = type == null ? ((Relation)AtomicFactory.create(this, this.getParentQuery())).addType(headAtom.getType()) : this;
        return atomWithType.isRuleApplicableViaAtom(headAtom);
    }

    private boolean hasMetaRoles() {
        Set parentRoles = this.getRoleVarMap().keySet();
        for (RoleType role : parentRoles) {
            if (!Schema.MetaSchema.isMetaLabel((TypeLabel)role.getLabel())) continue;
            return true;
        }
        return false;
    }

    private Set<RoleType> getExplicitRoleTypes() {
        HashSet<RoleType> roleTypes = new HashSet<RoleType>();
        ReasonerQueryImpl parent = (ReasonerQueryImpl)this.getParentQuery();
        GraknGraph graph = parent.graph();
        Set roleVars = this.getRelationPlayers().stream().map(RelationPlayer::getRoleType).flatMap(CommonUtil::optionalToStream).collect(Collectors.toSet());
        roleVars.stream().map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).map(arg_0 -> ((GraknGraph)graph).getType(arg_0)).forEach(roleTypes::add);
        roleVars.stream().filter(VarPatternAdmin::isUserDefinedName).map(VarPatternAdmin::getVarName).map(parent::getIdPredicate).filter(Objects::nonNull).map(Predicate::getPredicate).map(arg_0 -> ((GraknGraph)graph).getConcept(arg_0)).forEach(roleTypes::add);
        return roleTypes;
    }

    public Relation addType(Type type) {
        this.typeId = type.getId();
        Var typeVariable = this.getValueVariable().getValue().isEmpty() ? Var.of((String)("rel-" + UUID.randomUUID().toString())) : this.getValueVariable();
        this.setPredicate(new IdPredicate(Graql.var(typeVariable).id(this.typeId).admin(), this.getParentQuery()));
        this.atomPattern = this.atomPattern.asVar().isa(Graql.var(typeVariable)).admin();
        this.setValueVariable(typeVariable);
        this.applicableRules = null;
        return this;
    }

    private Set<Type> inferEntityTypes(Answer sub) {
        if (sub.isEmpty()) {
            return Collections.emptySet();
        }
        Sets.SetView subbedVars = Sets.intersection(this.getRolePlayers(), (Set)sub.keySet());
        Sets.SetView untypedVars = Sets.difference((Set)subbedVars, this.getParentQuery().getVarTypeMap().keySet());
        return untypedVars.stream().map(v -> new Pair(v, (Object)sub.get(v))).filter(p -> ((Concept)p.getValue()).isEntity()).map(e -> {
            Concept c = (Concept)e.getValue();
            return c.asInstance().type();
        }).collect(Collectors.toSet());
    }

    public List<RelationType> inferPossibleRelationTypes(Answer sub) {
        Multimap<RelationType, RoleType> compatibleTypesFromRoles = ReasonerUtils.getCompatibleRelationTypesWithRoles(this.getExplicitRoleTypes(), new RoleTypeConverter());
        Map varTypeMap = this.getParentQuery().getVarTypeMap();
        Set types = this.getRolePlayers().stream().filter(varTypeMap::containsKey).map(varTypeMap::get).collect(Collectors.toSet());
        this.inferEntityTypes(sub).forEach(types::add);
        Multimap<RelationType, RoleType> compatibleTypesFromTypes = ReasonerUtils.getCompatibleRelationTypesWithRoles(types, new TypeConverterImpl());
        Multimap<RelationType, RoleType> compatibleTypes = compatibleTypesFromRoles.isEmpty() ? compatibleTypesFromTypes : (!compatibleTypesFromTypes.isEmpty() ? ReasonerUtils.multimapIntersection(compatibleTypesFromTypes, compatibleTypesFromRoles) : compatibleTypesFromRoles);
        return compatibleTypes.asMap().entrySet().stream().sorted(Comparator.comparing(e -> -((Collection)e.getValue()).size())).map(Map.Entry::getKey).filter(t -> Sets.intersection(ReasonerUtils.getSuperTypes((Type)t), (Set)compatibleTypes.keySet()).isEmpty()).collect(Collectors.toList());
    }

    private Relation inferRelationType(Answer sub) {
        List<RelationType> relationTypes = this.inferPossibleRelationTypes(sub);
        if (relationTypes.size() == 1) {
            this.addType((Type)relationTypes.iterator().next());
        }
        return this;
    }

    @Override
    public void inferTypes() {
        if (this.getPredicate() == null) {
            this.inferRelationType(new QueryAnswer());
        }
        if (this.getExplicitRoleTypes().size() < this.getRelationPlayers().size() && this.getType() != null) {
            this.computeRoleVarTypeMap();
        }
    }

    @Override
    public Set<Var> getVarNames() {
        Set<Var> vars = super.getVarNames();
        vars.addAll(this.getRolePlayers());
        this.getRelationPlayers().stream().map(RelationPlayer::getRoleType).flatMap(CommonUtil::optionalToStream).filter(VarPatternAdmin::isUserDefinedName).forEach(r -> vars.add(r.getVarName()));
        return vars;
    }

    public Set<Var> getRolePlayers() {
        HashSet<Var> vars = new HashSet<Var>();
        this.getRelationPlayers().forEach(c -> vars.add(c.getRolePlayer().getVarName()));
        return vars;
    }

    private Set<Var> getMappedRolePlayers() {
        return this.getRoleVarMap().entries().stream().filter(e -> !Schema.MetaSchema.isMetaLabel((TypeLabel)((RoleType)e.getKey()).getLabel())).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    public Set<Var> getUnmappedRolePlayers() {
        Set<Var> unmappedVars = this.getRolePlayers();
        unmappedVars.removeAll(this.getMappedRolePlayers());
        return unmappedVars;
    }

    @Override
    public Set<IdPredicate> getUnmappedIdPredicates() {
        Set<Var> unmappedVars = this.getUnmappedRolePlayers();
        return this.getIdPredicates().stream().filter(pred -> unmappedVars.contains(pred.getVarName())).collect(Collectors.toSet());
    }

    @Override
    public Set<TypeAtom> getMappedTypeConstraints() {
        Set<Var> mappedVars = this.getMappedRolePlayers();
        return this.getTypeConstraints().stream().filter(t -> mappedVars.contains(t.getVarName())).filter(t -> Objects.nonNull(t.getType())).collect(Collectors.toSet());
    }

    @Override
    public Set<TypeAtom> getUnmappedTypeConstraints() {
        Set<Var> unmappedVars = this.getUnmappedRolePlayers();
        return this.getTypeConstraints().stream().filter(t -> unmappedVars.contains(t.getVarName())).filter(t -> Objects.nonNull(t.getType())).collect(Collectors.toSet());
    }

    @Override
    public Set<Unifier> getPermutationUnifiers(Atom headAtom) {
        if (!headAtom.isRelation()) {
            return new HashSet<Unifier>();
        }
        ArrayList<Var> permuteVars = new ArrayList<Var>();
        Relation relAtom = this.getValueVariable().getValue().isEmpty() ? ((Relation)AtomicFactory.create(this, this.getParentQuery())).addType(headAtom.getType()) : this;
        relAtom.getUnmappedRolePlayers().forEach(permuteVars::add);
        List<List<Var>> varPermutations = ReasonerUtils.getListPermutations(new ArrayList(permuteVars));
        return ReasonerUtils.getUnifiersFromPermutations(permuteVars, varPermutations);
    }

    private Multimap<RoleType, Var> computeRoleVarTypeMap() {
        this.roleVarMap = ArrayListMultimap.create();
        if (this.getParentQuery() == null || this.getType() == null) {
            return this.roleVarMap;
        }
        GraknGraph graph = this.getParentQuery().graph();
        RelationType relType = (RelationType)this.getType();
        Map varTypeMap = this.getParentQuery().getVarTypeMap();
        HashSet<RelationPlayer> allocatedRelationPlayers = new HashSet<RelationPlayer>();
        ArrayList<Pair<Var, VarPattern>> rolePlayerMappings = new ArrayList<Pair<Var, VarPattern>>();
        this.getRelationPlayers().forEach(c -> {
            Var varName = c.getRolePlayer().getVarName();
            VarPatternAdmin role = c.getRoleType().orElse(null);
            if (role != null) {
                IdPredicate rolePredicate;
                RoleType roleType;
                rolePlayerMappings.add(new Pair((Object)varName, (Object)role));
                TypeLabel typeLabel = role.getTypeLabel().orElse(null);
                RoleType roleType2 = roleType = typeLabel != null ? (RoleType)graph.getType(typeLabel) : null;
                if (roleType == null && role.isUserDefinedName() && (rolePredicate = ((ReasonerQueryImpl)this.getParentQuery()).getIdPredicate(role.getVarName())) != null) {
                    roleType = (RoleType)graph.getConcept((ConceptId)rolePredicate.getPredicate());
                }
                allocatedRelationPlayers.add((RelationPlayer)c);
                if (roleType != null) {
                    this.roleVarMap.put((Object)roleType, (Object)varName);
                }
            }
        });
        HashSet possibleRoles = Sets.newHashSet((Iterable)relType.relates());
        HashMap mappings = new HashMap();
        Sets.difference(this.getRelationPlayers(), allocatedRelationPlayers).forEach(casting -> {
            Var varName = casting.getRolePlayer().getVarName();
            Type type = (Type)varTypeMap.get(varName);
            if (type != null && !Schema.MetaSchema.isMetaLabel((TypeLabel)type.getLabel())) {
                mappings.put(casting, ReasonerUtils.getCompatibleRoleTypes(type, possibleRoles));
            } else {
                mappings.put(casting, ReasonerUtils.getTopTypes(possibleRoles));
            }
        });
        while (mappings.values().stream().filter(s -> s.size() == 1).count() != 0L) {
            Map.Entry entry = mappings.entrySet().stream().filter(e -> ((Set)e.getValue()).size() == 1).findFirst().orElse(null);
            RelationPlayer casting2 = (RelationPlayer)entry.getKey();
            Var varName = casting2.getRolePlayer().getVarName();
            RoleType roleType = (RoleType)((Set)entry.getValue()).iterator().next();
            VarPatternAdmin roleVar = Graql.var().label(roleType.getLabel()).admin();
            ((Set)mappings.get(casting2)).remove(roleType);
            rolePlayerMappings.add((Pair<Var, VarPattern>)new Pair((Object)varName, (Object)roleVar));
            this.roleVarMap.put((Object)roleType, (Object)varName);
            allocatedRelationPlayers.add(casting2);
        }
        RoleType metaRole = graph.admin().getMetaRoleType();
        VarPatternAdmin metaRoleVar = Graql.var().label(metaRole.getLabel()).admin();
        Sets.difference(this.getRelationPlayers(), allocatedRelationPlayers).forEach(casting -> {
            Var varName = casting.getRolePlayer().getVarName();
            this.roleVarMap.put((Object)metaRole, (Object)varName);
            rolePlayerMappings.add(new Pair((Object)varName, (Object)metaRoleVar));
        });
        this.atomPattern = Relation.constructRelationVar(this.isUserDefinedName() ? this.getVarName() : Var.of((String)""), this.getValueVariable(), rolePlayerMappings);
        this.relationPlayers = null;
        return this.roleVarMap;
    }

    public Multimap<RoleType, Var> getRoleVarMap() {
        if (this.roleVarMap == null) {
            this.computeRoleVarTypeMap();
        }
        return this.roleVarMap;
    }

    private Multimap<RoleType, RelationPlayer> getRoleRelationPlayerMap() {
        HashMultimap roleRelationPlayerMap = HashMultimap.create();
        Multimap<RoleType, Var> roleVarTypeMap = this.getRoleVarMap();
        Set<RelationPlayer> relationPlayers = this.getRelationPlayers();
        roleVarTypeMap.asMap().entrySet().forEach(arg_0 -> Relation.lambda$getRoleRelationPlayerMap$28(relationPlayers, (Multimap)roleRelationPlayerMap, arg_0));
        return roleRelationPlayerMap;
    }

    private Set<Pair<RelationPlayer, RelationPlayer>> getRelationPlayerMappings(Relation parentAtom) {
        HashSet<Pair<RelationPlayer, RelationPlayer>> rolePlayerMappings = new HashSet<Pair<RelationPlayer, RelationPlayer>>();
        HashMultimap compatibleMappings = HashMultimap.create();
        parentAtom.getRoleRelationPlayerMap();
        Multimap<RoleType, RelationPlayer> childRoleRPMap = this.getRoleRelationPlayerMap();
        Map parentVarTypeMap = parentAtom.getParentQuery().getVarTypeMap();
        Map childVarTypeMap = this.getParentQuery().getVarTypeMap();
        HashSet relationRoles = new HashSet(this.getType().asRelationType().relates());
        HashSet childRoles = new HashSet(childRoleRPMap.keySet());
        parentAtom.getRelationPlayers().stream().filter(prp -> prp.getRoleType().isPresent()).forEach(arg_0 -> this.lambda$getRelationPlayerMappings$34(parentVarTypeMap, childRoles, relationRoles, childRoleRPMap, childVarTypeMap, (Multimap)compatibleMappings, arg_0));
        while (compatibleMappings.asMap().values().stream().filter(s -> !s.isEmpty()).count() > 0L) {
            Map.Entry entry = compatibleMappings.entries().stream().sorted(Comparator.comparing(e -> {
                Type parentType = (Type)parentVarTypeMap.get(((RelationPlayer)e.getKey()).getRolePlayer().getVarName());
                Type childType = (Type)childVarTypeMap.get(((RelationPlayer)e.getValue()).getRolePlayer().getVarName());
                return parentType == null || childType == null || !parentType.equals(childType);
            })).sorted(Comparator.comparing(e -> {
                IdPredicate parentId = parentAtom.getIdPredicates().stream().filter(p -> p.getVarName().equals((Object)((RelationPlayer)e.getKey()).getRolePlayer().getVarName())).findFirst().orElse(null);
                IdPredicate childId = this.getIdPredicates().stream().filter(p -> p.getVarName().equals((Object)((RelationPlayer)e.getValue()).getRolePlayer().getVarName())).findFirst().orElse(null);
                return parentId == null || childId == null || !((ConceptId)parentId.getPredicate()).equals(childId.getPredicate());
            })).sorted(Comparator.comparing(arg_0 -> Relation.lambda$getRelationPlayerMappings$40((Multimap)compatibleMappings, arg_0))).findFirst().orElse(null);
            RelationPlayer parentCasting = (RelationPlayer)entry.getKey();
            RelationPlayer childCasting = (RelationPlayer)entry.getValue();
            rolePlayerMappings.add((Pair<RelationPlayer, RelationPlayer>)new Pair((Object)childCasting, (Object)parentCasting));
            compatibleMappings.removeAll((Object)parentCasting);
            compatibleMappings.values().remove(childCasting);
        }
        return rolePlayerMappings;
    }

    @Override
    public Unifier getUnifier(Atom pAtom) {
        if (this.equals(pAtom)) {
            return new UnifierImpl();
        }
        Unifier unifier = super.getUnifier(pAtom);
        if (pAtom.isRelation()) {
            Relation parentAtom = (Relation)pAtom;
            this.getRelationPlayerMappings(parentAtom).forEach(rpm -> unifier.addMapping(((RelationPlayer)rpm.getKey()).getRolePlayer().getVarName(), ((RelationPlayer)rpm.getValue()).getRolePlayer().getVarName()));
        }
        return unifier.removeTrivialMappings();
    }

    @Override
    public Atom rewriteToUserDefined() {
        VarPattern newVar = Graql.var(Var.anon());
        VarPattern relVar = this.getPattern().asVar().getProperty(IsaProperty.class).map(prop -> newVar.isa((VarPattern)prop.getType())).orElse(newVar);
        for (RelationPlayer c : this.getRelationPlayers()) {
            VarPatternAdmin roleType = c.getRoleType().orElse(null);
            if (roleType != null) {
                relVar = relVar.rel((VarPattern)roleType, (VarPattern)c.getRolePlayer());
                continue;
            }
            relVar = relVar.rel((VarPattern)c.getRolePlayer());
        }
        return new Relation(relVar.admin(), this.getPredicate(), this.getParentQuery());
    }

    private static /* synthetic */ Integer lambda$getRelationPlayerMappings$40(Multimap compatibleMappings, Map.Entry e) {
        return compatibleMappings.get(e.getKey()).size();
    }

    private /* synthetic */ void lambda$getRelationPlayerMappings$34(Map parentVarTypeMap, Set childRoles, Set relationRoles, Multimap childRoleRPMap, Map childVarTypeMap, Multimap compatibleMappings, RelationPlayer prp) {
        RoleType parentRole;
        VarPatternAdmin parentRoleTypeVar = prp.getRoleType().orElse(null);
        TypeLabel parentRoleTypeLabel = parentRoleTypeVar.getTypeLabel().orElse(null);
        RoleType roleType = parentRole = parentRoleTypeLabel != null ? (RoleType)this.graph().getType(parentRoleTypeLabel) : null;
        if (parentRole != null) {
            Set<Object> compatibleChildRoles;
            boolean isMetaRole = Schema.MetaSchema.isMetaLabel((TypeLabel)parentRole.getLabel());
            Var parentRolePlayer = prp.getRolePlayer().getVarName();
            Type parentType = (Type)parentVarTypeMap.get(parentRolePlayer);
            HashSet hashSet = compatibleChildRoles = isMetaRole ? childRoles : Sets.intersection(new HashSet(parentRole.subTypes()), (Set)childRoles);
            if (parentType != null) {
                HashSet typeRoles;
                boolean isMetaType = Schema.MetaSchema.isMetaLabel((TypeLabel)parentType.getLabel());
                HashSet hashSet2 = typeRoles = isMetaType ? childRoles : new HashSet(parentType.plays());
                compatibleChildRoles = Sets.intersection((Set)relationRoles, (Set)typeRoles).isEmpty() ? new HashSet() : compatibleChildRoles.stream().filter(rc -> Schema.MetaSchema.isMetaLabel((TypeLabel)rc.getLabel()) || typeRoles.contains(rc)).collect(Collectors.toSet());
            }
            compatibleChildRoles.stream().filter(arg_0 -> ((Multimap)childRoleRPMap).containsKey(arg_0)).forEach(r -> {
                Collection childRPs = parentType != null ? (Collection)childRoleRPMap.get(r).stream().filter(rp -> {
                    Var childRolePlayer = rp.getRolePlayer().getVarName();
                    Type childType = (Type)childVarTypeMap.get(childRolePlayer);
                    return childType == null || !ReasonerUtils.checkTypesDisjoint(parentType, childType);
                }).collect(Collectors.toSet()) : childRoleRPMap.get(r);
                childRPs.forEach(rp -> compatibleMappings.put((Object)prp, rp));
            });
        }
    }

    private static /* synthetic */ void lambda$getRoleRelationPlayerMap$28(Set relationPlayers, Multimap roleRelationPlayerMap, Map.Entry e) {
        RoleType role = (RoleType)e.getKey();
        TypeLabel roleLabel = role.getLabel();
        relationPlayers.stream().filter(rp -> rp.getRoleType().isPresent()).forEach(rp -> {
            TypeLabel rl;
            VarPatternAdmin roleTypeVar = rp.getRoleType().orElse(null);
            TypeLabel typeLabel = rl = roleTypeVar != null ? (TypeLabel)roleTypeVar.getTypeLabel().orElse(null) : null;
            if (roleLabel != null && roleLabel.equals((Object)rl)) {
                roleRelationPlayerMap.put((Object)role, rp);
            }
        });
    }

    private static /* synthetic */ void lambda$getRoleTypeMap$7(Multimap roleTypeMap, Map varTypeMap, Map.Entry e) {
        roleTypeMap.put(e.getKey(), varTypeMap.get(e.getValue()));
    }
}

