/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicBase;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.binary.BinaryBase;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeAtom
extends Binary {
    public TypeAtom(VarPatternAdmin pattern, ReasonerQuery par) {
        this(pattern, null, par);
    }

    public TypeAtom(VarPatternAdmin pattern, IdPredicate p, ReasonerQuery par) {
        super(pattern, p, par);
    }

    public TypeAtom(Var var, Var valueVar, ConceptId typeId, ReasonerQuery par) {
        this(var, valueVar, new IdPredicate(Graql.var(valueVar).id(typeId).admin(), par), par);
    }

    public TypeAtom(Var var, Var valueVar, IdPredicate p, ReasonerQuery par) {
        this(Graql.var(var).isa(Graql.var(valueVar)).admin(), p, par);
    }

    protected TypeAtom(TypeAtom a) {
        super(a);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + (this.getTypeId() != null ? this.getTypeId().hashCode() : 0);
        hashCode = hashCode * 37 + this.getVarName().hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BinaryBase a2 = (BinaryBase)obj;
        return Objects.equals(this.getTypeId(), a2.getTypeId()) && this.getVarName().equals((Object)a2.getVarName());
    }

    @Override
    public String toString() {
        String typeString = (this.getType() != null ? this.getType().getLabel() : "") + "(" + this.getVarName() + ")";
        return typeString + this.getPredicates().stream().map(AtomicBase::toString).collect(Collectors.joining(""));
    }

    @Override
    protected ConceptId extractTypeId() {
        return this.getPredicate() != null ? (ConceptId)this.getPredicate().getPredicate() : null;
    }

    @Override
    protected Var extractValueVariableName(VarPatternAdmin var) {
        return ((VarPatternAdmin)((VarProperty)var.getProperties().findFirst().get()).getInnerVars().findFirst().get()).getVarName();
    }

    @Override
    protected void setValueVariable(Var var) {
        super.setValueVariable(var);
        this.atomPattern = this.atomPattern.asVar().mapProperty(IsaProperty.class, prop -> new IsaProperty(prop.getType().setVarName(var)));
    }

    @Override
    public Atomic copy() {
        return new TypeAtom(this);
    }

    public Set<TypeAtom> unify(Unifier u) {
        Collection vars = u.get(this.getVarName());
        Var valueVar = this.getValueVariable();
        return vars.isEmpty() ? Collections.singleton(this) : vars.stream().map(v -> new TypeAtom((Var)v, valueVar, this.getPredicate(), this.getParentQuery())).collect(Collectors.toSet());
    }

    @Override
    public boolean isType() {
        return true;
    }

    @Override
    public boolean isRuleApplicable(InferenceRule child) {
        Atom ruleAtom = child.getHead().getAtom();
        return this.getType() != null && this.getPattern().asVar().hasProperty(IsaProperty.class) && this.getType().subTypes().contains(ruleAtom.getType());
    }

    public boolean isSelectable() {
        return this.getPredicate() == null || this.getType() != null && (this.getType().isResourceType() || this.getType().isRelationType()) || !this.getNeighbours().findFirst().isPresent() || this.isRuleResolvable();
    }

    @Override
    public boolean isAllowedToFormRuleHead() {
        return this.getType() != null;
    }

    @Override
    public boolean requiresMaterialisation() {
        return this.isUserDefinedName() && this.getType() != null && this.getType().isRelationType();
    }

    @Override
    public int computePriority(Set<Var> subbedVars) {
        int priority = super.computePriority(subbedVars);
        priority += 0;
        return priority += this.getType() == null && !this.isRelation() ? -1000 : 0;
    }

    @Override
    public Type getType() {
        return this.getPredicate() != null ? (Type)this.getParentQuery().graph().getConcept((ConceptId)this.getPredicate().getPredicate()) : null;
    }
}

