/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.predicate;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.IdProperty;
import ai.grakn.graql.internal.pattern.property.LabelProperty;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.util.ErrorMessage;

public class IdPredicate
extends Predicate<ConceptId> {
    public IdPredicate(VarPatternAdmin pattern, ReasonerQuery par) {
        super(pattern, par);
    }

    public IdPredicate(Var varName, IdProperty prop, ReasonerQuery par) {
        this(IdPredicate.createIdVar(varName, prop.getId()), par);
    }

    public IdPredicate(Var varName, LabelProperty prop, ReasonerQuery par) {
        this(IdPredicate.createIdVar(varName, prop, par.graph()), par);
    }

    private IdPredicate(IdPredicate a) {
        super(a);
    }

    public IdPredicate(Var varName, Concept con, ReasonerQuery par) {
        super(IdPredicate.createIdVar(varName, con.getId()), par);
    }

    @Override
    public String toString() {
        return "[" + this.getVarName() + "/" + this.getPredicateValue() + "]";
    }

    @Override
    public Atomic copy() {
        return new IdPredicate(this);
    }

    @Override
    public boolean isIdPredicate() {
        return true;
    }

    @Override
    public String getPredicateValue() {
        return ((ConceptId)this.getPredicate()).getValue();
    }

    @Override
    protected ConceptId extractPredicate(VarPatternAdmin var) {
        return var.admin().getId().orElse(null);
    }

    private static VarPatternAdmin createIdVar(Var varName, ConceptId typeId) {
        return Graql.var(varName).id(typeId).admin();
    }

    private static VarPatternAdmin createIdVar(Var varName, LabelProperty prop, GraknGraph graph) {
        Type type = graph.getType(prop.getLabelValue());
        if (type == null) {
            throw new IllegalArgumentException(ErrorMessage.CANNOT_CREATE_IDPREDICATE.getMessage(new Object[]{prop.getLabelValue()}));
        }
        return Graql.var(varName).id(type.getId()).admin();
    }
}

