/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.predicate;

import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.NeqProperty;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import java.util.Set;
import java.util.stream.Stream;

public class NeqPredicate
extends Predicate<Var> {
    public NeqPredicate(Var varName, NeqProperty prop, ReasonerQuery parent) {
        super(Graql.var(varName).neq(Graql.var(prop.getVar().getVarName())).admin(), parent);
    }

    public NeqPredicate(NeqPredicate a) {
        super(a);
    }

    @Override
    public String toString() {
        return "[" + this.getVarName() + "!=" + this.getReferenceVarName() + "]";
    }

    @Override
    public Atomic copy() {
        return new NeqPredicate(this);
    }

    @Override
    public String getPredicateValue() {
        return ((Var)this.getPredicate()).getValue();
    }

    @Override
    protected Var extractPredicate(VarPatternAdmin pattern) {
        return ((NeqProperty)pattern.getProperties(NeqProperty.class).iterator().next()).getVar().getVarName();
    }

    @Override
    public boolean isNeqPredicate() {
        return true;
    }

    @Override
    public Set<Var> getVarNames() {
        Set<Var> vars = super.getVarNames();
        vars.add(this.getReferenceVarName());
        return vars;
    }

    private Var getReferenceVarName() {
        return (Var)this.getPredicate();
    }

    public static boolean notEqualsOperator(Answer answer, NeqPredicate atom) {
        return !answer.get(atom.getVarName()).equals(answer.get(atom.getReferenceVarName()));
    }

    public QueryAnswers filter(QueryAnswers answers) {
        QueryAnswers results = new QueryAnswers();
        Var refVarName = this.getReferenceVarName();
        answers.stream().filter((? super T answer) -> !answer.get(this.getVarName()).equals(answer.get(refVarName))).forEach(results::add);
        return results;
    }

    public Stream<Answer> filter(Stream<Answer> answers) {
        Var refVarName = this.getReferenceVarName();
        return answers.filter((? super T answer) -> !answer.get(this.getVarName()).equals(answer.get(refVarName)));
    }
}

