/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.predicate;

import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;

public class ValuePredicate
extends Predicate<ValuePredicateAdmin> {
    public ValuePredicate(VarPatternAdmin pattern, ReasonerQuery par) {
        super(pattern, par);
    }

    public ValuePredicate(Var varName, ValuePredicateAdmin pred, ReasonerQuery par) {
        this(ValuePredicate.createValueVar(varName, pred), par);
    }

    private ValuePredicate(ValuePredicate pred) {
        super(pred);
    }

    @Override
    public Atomic copy() {
        return new ValuePredicate(this);
    }

    public Set<ValuePredicate> unify(Unifier u) {
        Collection vars = u.get(this.getVarName());
        return vars.isEmpty() ? Collections.singleton(this) : vars.stream().map(v -> new ValuePredicate((Var)v, (ValuePredicateAdmin)this.getPredicate(), this.getParentQuery())).collect(Collectors.toSet());
    }

    public static VarPatternAdmin createValueVar(Var name, ValuePredicateAdmin pred) {
        return Graql.var(name).val((ai.grakn.graql.ValuePredicate)pred).admin();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Predicate a2 = (Predicate)obj;
        return this.getVarName().equals((Object)a2.getVarName()) && ((ValuePredicateAdmin)this.getPredicate()).getClass().equals(a2.getPredicate().getClass()) && this.getPredicateValue().equals(a2.getPredicateValue());
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.getVarName().hashCode();
        hashCode = hashCode * 37 + ((ValuePredicateAdmin)this.getPredicate()).getClass().hashCode();
        return hashCode;
    }

    @Override
    public boolean isEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ValuePredicate a2 = (ValuePredicate)obj;
        return ((ValuePredicateAdmin)this.getPredicate()).getClass().equals(((ValuePredicateAdmin)a2.getPredicate()).getClass()) && this.getPredicateValue().equals(a2.getPredicateValue());
    }

    @Override
    public int equivalenceHashCode() {
        int hashCode = super.equivalenceHashCode();
        hashCode = hashCode * 37 + ((ValuePredicateAdmin)this.getPredicate()).getClass().getName().hashCode();
        return hashCode;
    }

    @Override
    public boolean isValuePredicate() {
        return true;
    }

    @Override
    public String getPredicateValue() {
        return ((ValuePredicateAdmin)this.getPredicate()).getPredicate().map(P::getValue).map(Object::toString).orElse("");
    }

    @Override
    protected ValuePredicateAdmin extractPredicate(VarPatternAdmin pattern) {
        Iterator properties = pattern.getProperties(ValueProperty.class).iterator();
        ValueProperty property = (ValueProperty)properties.next();
        if (properties.hasNext()) {
            throw new IllegalStateException("Attempting creation of ValuePredicate atom with more than single predicate");
        }
        return property.getPredicate();
    }

    @Override
    public Set<Var> getVarNames() {
        Set<Var> vars = super.getVarNames();
        VarPatternAdmin innerVar = ((ValuePredicateAdmin)this.getPredicate()).getInnerVar().orElse(null);
        if (innerVar != null && innerVar.isUserDefinedName()) {
            vars.add(innerVar.getVarName());
        }
        return vars;
    }
}

