/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.cache;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.reasoner.iterator.LazyIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;

public abstract class Cache<Q extends ReasonerQuery, T extends Iterable<Answer>> {
    protected final boolean explanation;
    protected final Map<Q, Pair<Q, T>> cache = new HashMap<Q, Pair<Q, T>>();

    public Cache() {
        this.explanation = false;
    }

    public Cache(boolean explanation) {
        this.explanation = explanation;
    }

    public boolean contains(Q query) {
        return this.cache.containsKey(query);
    }

    public Set<Q> getQueries() {
        return this.cache.keySet();
    }

    public abstract T record(Q var1, T var2);

    public abstract Stream<Answer> record(Q var1, Stream<Answer> var2);

    public abstract LazyIterator<Answer> recordRetrieveLazy(Q var1, Stream<Answer> var2);

    public abstract T getAnswers(Q var1);

    public abstract Pair<T, Unifier> getAnswersWithUnifier(Q var1);

    public abstract Stream<Answer> getAnswerStream(Q var1);

    public abstract Pair<Stream<Answer>, Unifier> getAnswerStreamWithUnifier(Q var1);

    public abstract LazyIterator<Answer> getAnswerIterator(Q var1);

    public Map<Pair<Var, Concept>, Set<Answer>> getInverseAnswerMap(Q query, Set<Var> vars) {
        HashMap<Pair<Var, Concept>, Set<Answer>> inverseAnswerMap = new HashMap<Pair<Var, Concept>, Set<Answer>>();
        Set<Answer> answers = this.getAnswerStream(query).collect(Collectors.toSet());
        answers.forEach(answer -> answer.entrySet().stream().filter(e -> vars.contains(e.getKey())).forEach(entry -> {
            Pair key = new Pair(entry.getKey(), entry.getValue());
            Set match = (Set)inverseAnswerMap.get(key);
            if (match != null) {
                match.add(answer);
            } else {
                HashSet<Answer> ans = new HashSet<Answer>();
                ans.add((Answer)answer);
                inverseAnswerMap.put(key, ans);
            }
        }));
        return inverseAnswerMap;
    }

    public Map<Pair<Var, Concept>, Set<Answer>> getInverseAnswerMap(Q query) {
        return this.getInverseAnswerMap(query, query.getVarNames());
    }

    public void add(Cache<Q, T> c2) {
        c2.cache.keySet().forEach(q -> this.record(q, c2.getAnswers(q)));
    }

    public abstract void remove(Cache<Q, T> var1, Set<Q> var2);

    public void remove(Cache<Q, T> c2) {
        this.remove(c2, this.getQueries());
    }

    public void clear() {
        this.cache.clear();
    }

    public abstract long answerSize(Set<Q> var1);
}

