/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.cache;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.explanation.LookupExplanation;
import ai.grakn.graql.internal.reasoner.iterator.LazyAnswerIterator;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;

public class LazyQueryCache<Q extends ReasonerQuery>
extends Cache<Q, LazyAnswerIterator> {
    public LazyQueryCache() {
    }

    public LazyQueryCache(boolean explanation) {
        super(explanation);
    }

    @Override
    public LazyAnswerIterator record(Q query, LazyAnswerIterator answers) {
        Pair match = (Pair)this.cache.get(query);
        if (match != null) {
            ReasonerQuery equivalentQuery = (ReasonerQuery)match.getKey();
            Stream unifiedStream = answers.unify(query.getUnifier(equivalentQuery)).stream();
            this.cache.put(match.getKey(), new Pair(match.getKey(), (Object)((LazyAnswerIterator)match.getValue()).merge(unifiedStream)));
        } else {
            this.cache.put(query, new Pair(query, (Object)answers));
        }
        return this.getAnswerIterator((ReasonerQuery)query);
    }

    @Override
    public Stream<Answer> record(Q query, Stream<Answer> answers) {
        return this.recordRetrieveLazy((ReasonerQuery)query, (Stream)answers).stream();
    }

    public LazyAnswerIterator recordRetrieveLazy(Q query, Stream<Answer> answers) {
        Pair match = (Pair)this.cache.get(query);
        if (match != null) {
            ReasonerQuery equivalentQuery = (ReasonerQuery)match.getKey();
            Unifier u = query.getUnifier(equivalentQuery);
            Stream<Answer> unifiedStream = answers.map(a -> a.unify(u));
            this.cache.put(match.getKey(), new Pair(match.getKey(), (Object)((LazyAnswerIterator)match.getValue()).merge((Stream)unifiedStream)));
        } else {
            this.cache.put(query, new Pair(query, (Object)new LazyAnswerIterator(answers)));
        }
        return this.getAnswerIterator((ReasonerQuery)query);
    }

    @Override
    public LazyAnswerIterator getAnswers(Q query) {
        return (LazyAnswerIterator)this.getAnswersWithUnifier(query).getKey();
    }

    @Override
    public Pair<LazyAnswerIterator, Unifier> getAnswersWithUnifier(Q query) {
        Pair match = (Pair)this.cache.get(query);
        if (match != null) {
            ReasonerQuery equivalentQuery = (ReasonerQuery)match.getKey();
            LookupExplanation exp = new LookupExplanation((ReasonerQuery)query);
            Unifier unifier = equivalentQuery.getUnifier(query);
            LazyAnswerIterator unified = ((LazyAnswerIterator)match.getValue()).unify(unifier);
            if (this.explanation) {
                unified = unified.explain(exp);
            }
            return new Pair((Object)unified, (Object)unifier);
        }
        return new Pair((Object)new LazyAnswerIterator(Stream.empty()), (Object)new UnifierImpl());
    }

    @Override
    public Stream<Answer> getAnswerStream(Q query) {
        return (Stream)this.getAnswerStreamWithUnifier(query).getKey();
    }

    @Override
    public Pair<Stream<Answer>, Unifier> getAnswerStreamWithUnifier(Q query) {
        Pair match = (Pair)this.cache.get(query);
        if (match != null) {
            ReasonerQuery equivalentQuery = (ReasonerQuery)match.getKey();
            Unifier unifier = equivalentQuery.getUnifier(query);
            LookupExplanation exp = new LookupExplanation((ReasonerQuery)query);
            Stream<Answer> unified = ((LazyAnswerIterator)match.getValue()).stream().map(a -> a.unify(unifier));
            if (this.explanation) {
                unified = unified.map(a -> {
                    if (a.getExplanation() == null || a.getExplanation().isLookupExplanation()) {
                        a.explain(exp);
                    } else {
                        a.getExplanation().setQuery(query);
                    }
                    return a;
                });
            }
            return new Pair(unified, (Object)unifier);
        }
        return new Pair(Stream.empty(), (Object)new UnifierImpl());
    }

    public LazyAnswerIterator getAnswerIterator(Q query) {
        return this.getAnswers((ReasonerQuery)query);
    }

    @Override
    public long answerSize(Set<Q> queries) {
        return this.cache.values().stream().filter(p -> queries.contains(p.getKey())).map(v -> ((LazyAnswerIterator)v.getValue()).size()).mapToLong(Long::longValue).sum();
    }

    @Override
    public void remove(Cache<Q, LazyAnswerIterator> c2, Set<Q> queries) {
        c2.cache.keySet().stream().filter(queries::contains).filter(this::contains).forEach(q -> {
            Pair match = (Pair)this.cache.get(q);
            Set s = ((LazyAnswerIterator)match.getValue()).stream().collect(Collectors.toSet());
            s.removeAll(c2.getAnswerStream(q).collect(Collectors.toSet()));
            this.cache.put(match.getKey(), new Pair(match.getKey(), (Object)new LazyAnswerIterator(s.stream())));
        });
    }

    public void reload() {
        HashMap newCache = new HashMap();
        this.cache.entrySet().forEach(entry -> newCache.put(entry.getKey(), new Pair(entry.getKey(), (Object)new LazyAnswerIterator(((LazyAnswerIterator)((Pair)entry.getValue()).getValue()).stream().collect(Collectors.toSet()).stream()))));
        this.cache.clear();
        this.cache.putAll(newCache);
    }

    public void consume() {
        this.cache.entrySet().forEach(entry -> ((LazyAnswerIterator)((Pair)entry.getValue()).getValue()).stream().collect(Collectors.toSet()));
    }
}

