/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.cache;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.iterator.LazyIterator;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;

public class QueryCache<Q extends ReasonerQuery>
extends Cache<Q, QueryAnswers> {
    public QueryCache() {
    }

    public QueryCache(boolean explanation) {
        super(explanation);
    }

    @Override
    public QueryAnswers record(Q query, QueryAnswers answers) {
        ReasonerQuery equivalentQuery;
        ReasonerQuery reasonerQuery = equivalentQuery = this.contains(query) ? (ReasonerQuery)((Pair)this.cache.get(query)).getKey() : null;
        if (equivalentQuery != null) {
            QueryAnswers unifiedAnswers = QueryAnswers.getUnifiedAnswers(equivalentQuery, query, answers);
            ((QueryAnswers)((Pair)this.cache.get(query)).getValue()).addAll(unifiedAnswers);
        } else {
            this.cache.put(query, new Pair(query, (Object)answers));
        }
        return this.getAnswers((ReasonerQuery)query);
    }

    @Override
    public Stream<Answer> record(Q query, Stream<Answer> answerStream) {
        QueryAnswers newAnswers = new QueryAnswers(answerStream.collect(Collectors.toSet()));
        Pair match = (Pair)this.cache.get(query);
        if (match != null) {
            ReasonerQuery equivalentQuery = (ReasonerQuery)match.getKey();
            QueryAnswers answers = (QueryAnswers)match.getValue();
            QueryAnswers unifiedAnswers = newAnswers.unify(query.getUnifier(equivalentQuery));
            answers.addAll(unifiedAnswers);
            return answers.stream();
        }
        this.cache.put(query, new Pair(query, (Object)newAnswers));
        return newAnswers.stream();
    }

    public Answer getAnswer(Q query, Answer answer) {
        Pair match = (Pair)this.cache.get(query);
        if (match != null) {
            ReasonerQuery equivalentQuery = (ReasonerQuery)match.getKey();
            Unifier unifier = equivalentQuery.getUnifier(query);
            QueryAnswers answers = ((QueryAnswers)match.getValue()).unify(unifier);
            return answers.stream().filter(a -> a.containsAll(answer)).findFirst().orElse(new QueryAnswer());
        }
        return new QueryAnswer();
    }

    public Answer recordAnswer(Q query, Answer answer) {
        Pair match = (Pair)this.cache.get(query);
        if (match != null) {
            ReasonerQuery equivalentQuery = (ReasonerQuery)match.getKey();
            QueryAnswers answers = (QueryAnswers)match.getValue();
            Answer unifiedAnswer = answer.unify(query.getUnifier(equivalentQuery));
            answers.add(unifiedAnswer);
        } else {
            this.cache.put(query, new Pair(query, (Object)new QueryAnswers(answer)));
        }
        return answer;
    }

    public Answer recordAnswerWithUnifier(Q query, Answer answer, Unifier unifier) {
        Pair match = (Pair)this.cache.get(query);
        if (match != null) {
            QueryAnswers answers = (QueryAnswers)match.getValue();
            Answer unifiedAnswer = answer.unify(unifier);
            answers.add(unifiedAnswer);
        } else {
            this.cache.put(query, new Pair(query, (Object)new QueryAnswers(answer)));
        }
        return answer;
    }

    @Override
    public LazyIterator<Answer> recordRetrieveLazy(Q query, Stream<Answer> answers) {
        return new LazyIterator<Answer>(this.record(query, answers));
    }

    @Override
    public QueryAnswers getAnswers(Q query) {
        return (QueryAnswers)this.getAnswersWithUnifier(query).getKey();
    }

    @Override
    public Pair<QueryAnswers, Unifier> getAnswersWithUnifier(Q query) {
        Pair match = (Pair)this.cache.get(query);
        if (match != null) {
            ReasonerQuery equivalentQuery = (ReasonerQuery)match.getKey();
            QueryAnswers answers = (QueryAnswers)match.getValue();
            Unifier unifier = equivalentQuery.getUnifier(query);
            return new Pair((Object)answers.unify(unifier), (Object)unifier);
        }
        return new Pair((Object)new QueryAnswers(), (Object)new UnifierImpl());
    }

    @Override
    public Stream<Answer> getAnswerStream(Q query) {
        return ((QueryAnswers)this.getAnswers((ReasonerQuery)query)).stream();
    }

    @Override
    public Pair<Stream<Answer>, Unifier> getAnswerStreamWithUnifier(Q query) {
        Pair<QueryAnswers, Unifier> answersWithUnifier = this.getAnswersWithUnifier(query);
        return new Pair(((QueryAnswers)answersWithUnifier.getKey()).stream(), answersWithUnifier.getValue());
    }

    @Override
    public LazyIterator<Answer> getAnswerIterator(Q query) {
        return new LazyIterator<Answer>(((QueryAnswers)this.getAnswers((ReasonerQuery)query)).stream());
    }

    @Override
    public void remove(Cache<Q, QueryAnswers> c2, Set<Q> queries) {
        c2.cache.keySet().stream().filter(queries::contains).filter(this::contains).forEach(q -> ((QueryAnswers)((Pair)this.cache.get(q)).getValue()).removeAll((QueryAnswers)c2.getAnswers(q)));
    }

    @Override
    public long answerSize(Set<Q> queries) {
        return this.cache.values().stream().filter(p -> queries.contains(p.getKey())).map(v -> ((QueryAnswers)v.getValue()).size()).mapToInt(Integer::intValue).sum();
    }
}

