/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.explanation;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.ReasonerQuery;
import java.util.HashSet;
import java.util.Set;

public class Explanation
implements AnswerExplanation {
    private ReasonerQuery query;
    private final Set<Answer> answers;

    public Explanation() {
        this.answers = new HashSet<Answer>();
    }

    Explanation(ReasonerQuery q) {
        this.query = q;
        this.answers = new HashSet<Answer>();
    }

    Explanation(ReasonerQuery q, Set<Answer> ans) {
        this.query = q;
        this.answers = ans;
    }

    Explanation(Explanation e) {
        this.answers = e.answers;
        this.query = e.getQuery();
    }

    public AnswerExplanation copy() {
        return new Explanation(this);
    }

    public boolean addAnswer(Answer a) {
        return this.answers.add(a);
    }

    public Set<Answer> getAnswers() {
        return this.answers;
    }

    public boolean isLookupExplanation() {
        return false;
    }

    public boolean isRuleExplanation() {
        return false;
    }

    public boolean isJoinExplanation() {
        return !this.isLookupExplanation() && !this.isRuleExplanation();
    }

    public boolean isEmpty() {
        return !this.isLookupExplanation() && !this.isRuleExplanation() && this.getAnswers().isEmpty();
    }

    public ReasonerQuery getQuery() {
        return this.query;
    }

    public AnswerExplanation setQuery(ReasonerQuery q) {
        return new Explanation(q);
    }

    public AnswerExplanation merge(AnswerExplanation a2) {
        Explanation exp = new Explanation();
        if (this.isJoinExplanation()) {
            this.getAnswers().forEach(arg_0 -> ((AnswerExplanation)exp).addAnswer(arg_0));
        }
        if (a2.isJoinExplanation()) {
            a2.getAnswers().forEach(arg_0 -> ((AnswerExplanation)exp).addAnswer(arg_0));
        }
        return exp;
    }
}

