/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.admin.AnswerExplanation;
import ai.grakn.graql.admin.Atomic;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.Unifier;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.UnifierImpl;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.binary.Relation;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.cache.Cache;
import ai.grakn.graql.internal.reasoner.cache.LazyQueryCache;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.explanation.LookupExplanation;
import ai.grakn.graql.internal.reasoner.explanation.RuleExplanation;
import ai.grakn.graql.internal.reasoner.iterator.ReasonerQueryIterator;
import ai.grakn.graql.internal.reasoner.query.QueryAnswerStream;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQueryIterator;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.reasoner.rule.RuleTuple;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReasonerAtomicQuery
extends ReasonerQueryImpl {
    private Atom atom = this.selectAtoms().stream().findFirst().orElse(null);
    private static final Logger LOG = LoggerFactory.getLogger(ReasonerAtomicQuery.class);

    ReasonerAtomicQuery(Conjunction<VarPatternAdmin> pattern, GraknGraph graph) {
        super(pattern, graph);
    }

    ReasonerAtomicQuery(ReasonerQueryImpl query) {
        super(query);
    }

    ReasonerAtomicQuery(Atom at) {
        super(at);
    }

    @Override
    public ReasonerQuery copy() {
        return new ReasonerAtomicQuery(this);
    }

    @Override
    public String toString() {
        return this.getAtoms().stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    public Atom getAtom() {
        return this.atom;
    }

    @Override
    public boolean addAtomic(Atomic at) {
        if (super.addAtomic(at)) {
            if (this.atom == null && at.isSelectable()) {
                this.atom = (Atom)at;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAtomic(Atomic at) {
        if (super.removeAtomic(at)) {
            if (at.equals(this.atom)) {
                this.atom = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<Atom> selectAtoms() {
        Set<Atom> selectedAtoms = super.selectAtoms();
        if (selectedAtoms.size() != 1) {
            throw new IllegalStateException(ErrorMessage.NON_ATOMIC_QUERY.getMessage(new Object[]{this.toString()}));
        }
        return selectedAtoms;
    }

    @Override
    public Unifier getUnifier(ReasonerQuery p) {
        if (p == this) {
            return new UnifierImpl();
        }
        ReasonerAtomicQuery parent = (ReasonerAtomicQuery)p;
        Unifier unifier = this.getAtom().getUnifier(parent.getAtom());
        HashSet unified = new HashSet();
        this.getAtom().getTypeConstraints().forEach(type -> {
            Sets.SetView toUnify = Sets.difference(parent.getEquivalentAtoms((Atom)type), (Set)unified);
            Atom equiv = toUnify.stream().findFirst().orElse(null);
            if (equiv != null && toUnify.size() == 1) {
                unifier.merge(type.getUnifier(equiv));
                unified.add(equiv);
            }
        });
        return unifier;
    }

    public Stream<Answer> lookup(Cache<ReasonerAtomicQuery, ?> cache) {
        boolean queryVisited = cache.contains(this);
        return queryVisited ? cache.getAnswerStream(this) : this.DBlookup(cache);
    }

    Answer lookupAnswer(QueryCache<ReasonerAtomicQuery> cache, Answer sub) {
        Answer answer;
        boolean queryVisited = cache.contains(this);
        if (queryVisited && !(answer = cache.getAnswer(this, sub)).isEmpty()) {
            return answer;
        }
        List match = (List)new ReasonerAtomicQuery(this).addSubstitution(sub).getMatchQuery().execute();
        return match.isEmpty() ? new QueryAnswer() : (Answer)match.iterator().next();
    }

    Pair<Stream<Answer>, Unifier> lookupWithUnifier(Cache<ReasonerAtomicQuery, ?> cache) {
        boolean queryVisited = cache.contains(this);
        return queryVisited ? cache.getAnswerStreamWithUnifier(this) : new Pair(this.DBlookup(), (Object)new UnifierImpl());
    }

    private Stream<Answer> DBlookup() {
        return this.getMatchQuery().admin().stream().map(QueryAnswer::new).map(a -> a.explain(new LookupExplanation(this)));
    }

    private Stream<Answer> DBlookup(Cache<ReasonerAtomicQuery, ?> cache) {
        return cache.record(this, this.DBlookup());
    }

    private Stream<Answer> insert() {
        return Graql.insert(this.getPattern().getVars()).withGraph(this.graph()).stream();
    }

    public Stream<Answer> materialise(Answer answer) {
        ReasonerAtomicQuery queryToMaterialise = new ReasonerAtomicQuery(this);
        queryToMaterialise.addSubstitution(answer);
        return queryToMaterialise.insert().map(ans -> ans.setExplanation(answer.getExplanation()));
    }

    private Set<Unifier> getPermutationUnifiers(Atom headAtom) {
        if (!this.atom.isRelation() || !headAtom.isRelation()) {
            return Collections.singleton(new UnifierImpl());
        }
        Relation relAtom = this.atom.getType() == null ? ((Relation)AtomicFactory.create(this.atom, this.atom.getParentQuery())).addType(headAtom.getType()) : (Relation)this.atom;
        ArrayList<Var> permuteVars = new ArrayList<Var>(relAtom.getUnmappedRolePlayers());
        if (!this.atom.isRelation() || !headAtom.isRelation() || permuteVars.isEmpty()) {
            return Collections.singleton(new UnifierImpl());
        }
        List<List<Var>> varPermutations = ReasonerUtils.getListPermutations(new ArrayList<Var>(permuteVars)).stream().filter(l -> !l.isEmpty()).collect(Collectors.toList());
        return ReasonerUtils.getUnifiersFromPermutations(permuteVars, varPermutations);
    }

    private Stream<Answer> getIdPredicateAnswerStream(Stream<Answer> stream) {
        Answer idPredicateAnswer = this.getSubstitution();
        return stream.map(answer -> {
            AnswerExplanation exp = answer.getExplanation();
            return answer.merge(idPredicateAnswer).explain(exp);
        });
    }

    private Stream<Answer> getFilteredAnswerStream(Stream<Answer> answers) {
        Set<Var> vars = this.getVarNames();
        Set<TypeAtom> mappedTypeConstraints = this.atom.getMappedTypeConstraints();
        return this.getIdPredicateAnswerStream(answers).filter(a -> QueryAnswerStream.entityTypeFilter(a, mappedTypeConstraints)).map(a -> a.filterVars(vars));
    }

    private Stream<Answer> resolveViaRule(InferenceRule rule, Unifier ruleUnifier, Unifier permutationUnifier, Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache, boolean materialise, boolean explanation, boolean differentialJoin) {
        Atom atom = this.getAtom();
        LOG.trace("Applying rule " + rule.getRuleId());
        ReasonerQueryImpl ruleBody = rule.getBody();
        ReasonerAtomicQuery ruleHead = rule.getHead();
        Set<Var> varsToRetain = rule.hasDisconnectedHead() ? ruleBody.getVarNames() : ruleHead.getVarNames();
        subGoals.add(this);
        Stream<Object> answers = ruleBody.computeJoin(subGoals, cache, dCache, materialise, explanation, differentialJoin).map(a -> a.filterVars(varsToRetain)).distinct().map(ans -> ans.explain((AnswerExplanation)new RuleExplanation((ReasonerQuery)this, rule)));
        if (materialise || rule.requiresMaterialisation(atom)) {
            if (!cache.contains(ruleHead)) {
                dCache.record(ruleHead, ruleHead.lookup(cache));
            }
            Map<Pair<Var, Concept>, Set<Answer>> known = cache.getInverseAnswerMap(ruleHead);
            Map<Pair<Var, Concept>, Set<Answer>> dknown = dCache.getInverseAnswerMap(ruleHead);
            answers = answers.filter(a -> QueryAnswerStream.knownFilterWithInverse(a, known)).filter(a -> QueryAnswerStream.knownFilterWithInverse(a, dknown)).flatMap(ruleHead::materialise);
            answers = dCache.record(ruleHead, answers);
        }
        boolean isHeadEquivalent = this.isEquivalent(ruleHead);
        Set<Var> queryVars = this.getVarNames().size() < ruleHead.getVarNames().size() ? ruleUnifier.keySet() : ruleHead.getVarNames();
        answers = answers.map(a -> a.filterVars(queryVars)).map(a -> a.unify(ruleUnifier)).map(a -> a.unify(permutationUnifier)).filter(a -> !a.isEmpty());
        return isHeadEquivalent ? dCache.record(this, answers) : dCache.record(this, this.getFilteredAnswerStream(answers));
    }

    Stream<Answer> answerStream(Set<ReasonerAtomicQuery> subGoals, Cache<ReasonerAtomicQuery, ?> cache, Cache<ReasonerAtomicQuery, ?> dCache, boolean materialise, boolean explanation, boolean differentialJoin) {
        Stream<Answer> answerStream;
        boolean queryAdmissible = !subGoals.contains(this);
        LOG.trace("AQ: " + this);
        Stream<Answer> stream = answerStream = cache.contains(this) ? Stream.empty() : dCache.record(this, this.lookup(cache));
        if (queryAdmissible) {
            Iterator<RuleTuple> ruleIterator = this.getRuleIterator();
            while (ruleIterator.hasNext()) {
                RuleTuple ruleContext = ruleIterator.next();
                InferenceRule rule = ruleContext.getRule();
                Unifier u = ruleContext.getRuleUnifier();
                Unifier pu = ruleContext.getPermutationUnifier();
                Answer sub = this.getSubstitution().unify(u.inverse());
                rule.getHead().addSubstitution(sub);
                rule.getBody().addSubstitution(sub);
                Stream<Answer> localStream = this.resolveViaRule(rule, u, pu, subGoals, cache, dCache, materialise, explanation, differentialJoin);
                answerStream = Stream.concat(answerStream, localStream);
            }
        }
        return dCache.record(this, answerStream);
    }

    @Override
    public Stream<Answer> resolve(boolean materialise, boolean explanation, LazyQueryCache<ReasonerAtomicQuery> cache, LazyQueryCache<ReasonerAtomicQuery> dCache) {
        if (!this.getAtom().isRuleResolvable()) {
            return this.getMatchQuery().admin().stream().map(QueryAnswer::new);
        }
        return new QueryAnswerIterator(materialise, explanation, cache, dCache).hasStream();
    }

    @Override
    public Iterator<Answer> iterator(Answer sub, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        Iterator qIterator = this.getQueryStream(sub).map(q -> new ReasonerAtomicQueryIterator((ReasonerAtomicQuery)q, sub, subGoals, cache)).iterator();
        return Iterators.concat(qIterator);
    }

    private Stream<ReasonerAtomicQuery> getQueryStream(Answer sub) {
        Atom atom = this.getAtom();
        if (!atom.isRelation() || atom.getType() != null) {
            return Stream.of(this);
        }
        List<RelationType> relationTypes = ((Relation)atom).inferPossibleRelationTypes(sub);
        LOG.trace("AQ: " + this + ": inferred rel types for: " + relationTypes.stream().map(Type::getLabel).collect(Collectors.toList()));
        return relationTypes.stream().map(type -> ((Relation)AtomicFactory.create(atom, atom.getParentQuery())).addType((Type)type)).map(ReasonerAtomicQuery::new);
    }

    Iterator<RuleTuple> getRuleIterator() {
        return this.getAtom().getApplicableRules().stream().flatMap(r -> {
            r.rewriteToUserDefined(this.getAtom());
            Unifier ruleUnifier = r.getUnifier(this.getAtom());
            Unifier ruleUnifierInv = ruleUnifier.inverse();
            return this.getPermutationUnifiers(r.getHead().getAtom()).stream().map(permutationUnifier -> new RuleTuple(new InferenceRule((InferenceRule)r).propagateConstraints(this.getAtom(), permutationUnifier.combine(ruleUnifierInv)), ruleUnifier, (Unifier)permutationUnifier));
        }).sorted(Comparator.comparing(rt -> -rt.getRule().resolutionPriority())).iterator();
    }

    private class QueryAnswerIterator
    extends ReasonerQueryIterator {
        private int iter = 0;
        private long answers = 0L;
        private final boolean materialise;
        private final boolean explanation;
        private final Set<ReasonerAtomicQuery> subGoals = new HashSet<ReasonerAtomicQuery>();
        private final LazyQueryCache<ReasonerAtomicQuery> cache;
        private final LazyQueryCache<ReasonerAtomicQuery> dCache;
        private Iterator<Answer> answerIterator;

        QueryAnswerIterator(boolean materialise, boolean explanation, LazyQueryCache<ReasonerAtomicQuery> cache, LazyQueryCache<ReasonerAtomicQuery> dCache) {
            this.materialise = materialise;
            this.explanation = explanation;
            this.cache = cache;
            this.dCache = dCache;
            this.answerIterator = this.query().answerStream(this.subGoals, cache, dCache, materialise, explanation, this.iter != 0).iterator();
        }

        private ReasonerAtomicQuery query() {
            return ReasonerAtomicQuery.this;
        }

        @Override
        public Stream<Answer> hasStream() {
            Iterable iterable = () -> this;
            return StreamSupport.stream(iterable.spliterator(), false).distinct().peek(ans -> ++this.answers);
        }

        private void computeNext() {
            ++this.iter;
            this.subGoals.clear();
            this.answerIterator = this.query().answerStream(this.subGoals, this.cache, this.dCache, this.materialise, this.explanation, this.iter != 0).iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.answerIterator.hasNext()) {
                return true;
            }
            this.updateCache();
            long dAns = this.differentialAnswerSize();
            if (dAns != 0L || this.iter == 0) {
                LOG.debug("Atom: " + this.query().getAtom() + " iter: " + this.iter + " answers: " + this.answers + " dAns = " + dAns);
                this.computeNext();
                return this.answerIterator.hasNext();
            }
            return false;
        }

        private void updateCache() {
            this.dCache.remove(this.cache);
            this.cache.add(this.dCache);
            this.cache.reload();
        }

        @Override
        public Answer next() {
            return this.answerIterator.next();
        }

        private long differentialAnswerSize() {
            return this.dCache.answerSize(this.subGoals);
        }
    }
}

