/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.iterator.ReasonerQueryIterator;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

class ReasonerQueryImplCumulativeIterator
extends ReasonerQueryIterator {
    private final Answer partialSub;
    private final LinkedList<ReasonerAtomicQuery> nextList;
    private final QueryCache<ReasonerAtomicQuery> cache;
    private final Set<ReasonerAtomicQuery> subGoals;
    private final Iterator<Answer> atomicQueryIterator;
    private Iterator<Answer> queryIterator;

    ReasonerQueryImplCumulativeIterator(Answer sub, LinkedList<ReasonerAtomicQuery> qs, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        this.subGoals = subGoals;
        this.cache = cache;
        this.partialSub = sub;
        this.nextList = Lists.newLinkedList(qs);
        Iterator<Answer> iterator = this.nextList.removeFirst().iterator(sub, subGoals, cache);
        this.queryIterator = this.nextList.isEmpty() ? iterator : Collections.emptyIterator();
        this.atomicQueryIterator = this.nextList.isEmpty() ? Collections.emptyIterator() : iterator;
    }

    @Override
    public boolean hasNext() {
        if (this.queryIterator.hasNext()) {
            return true;
        }
        if (this.atomicQueryIterator.hasNext() && !this.nextList.isEmpty()) {
            Answer feederSub = this.atomicQueryIterator.next();
            this.queryIterator = new ReasonerQueryImplCumulativeIterator(feederSub.merge(this.partialSub), this.nextList, this.subGoals, this.cache);
            return this.hasNext();
        }
        return false;
    }

    @Override
    public Answer next() {
        Answer sub = this.queryIterator.next();
        sub = sub.merge(this.partialSub, true);
        return sub;
    }
}

