/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.graql.admin.Answer;
import ai.grakn.graql.internal.query.QueryAnswer;
import ai.grakn.graql.internal.reasoner.cache.QueryCache;
import ai.grakn.graql.internal.reasoner.iterator.ReasonerQueryIterator;
import ai.grakn.graql.internal.reasoner.query.ReasonerAtomicQuery;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImpl;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueryImplCumulativeIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReasonerQueryImplIterator
extends ReasonerQueryIterator {
    private final Iterator<Answer> queryIterator;
    private static final Logger LOG = LoggerFactory.getLogger(ReasonerQueryImpl.class);

    ReasonerQueryImplIterator(ReasonerQueryImpl q, Answer sub, Set<ReasonerAtomicQuery> subGoals, QueryCache<ReasonerAtomicQuery> cache) {
        ReasonerQueryImpl query = new ReasonerQueryImpl(q);
        query.addSubstitution(sub);
        LOG.trace("CQ: " + query);
        LinkedList<ReasonerAtomicQuery> queries = query.getResolutionPlan();
        LOG.trace("CQ plan:\n" + queries.stream().map(aq -> aq.toString() + (aq.isRuleResolvable() ? "*" : "")).collect(Collectors.joining("\n")));
        this.queryIterator = new ReasonerQueryImplCumulativeIterator(new QueryAnswer(), queries, subGoals, cache);
    }

    @Override
    public boolean hasNext() {
        return this.queryIterator.hasNext();
    }

    @Override
    public Answer next() {
        return this.queryIterator.next();
    }
}

