/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.template;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ObjectUtils;

public class Scope {
    private final Scope parent;
    private final Map<String, Object> values;
    private final Set<String> variablesEncountered;

    public Scope(Map<String, Object> data) {
        this.parent = null;
        this.values = new HashMap<String, Object>();
        this.variablesEncountered = new HashSet<String>();
        this.assign("", data);
    }

    public Scope(Scope parent) {
        this.parent = parent;
        this.values = new HashMap<String, Object>();
        this.variablesEncountered = Sets.newHashSet(parent.variablesEncountered);
    }

    public Scope up() {
        return this.parent;
    }

    public void assign(String prefix, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            if (!prefix.isEmpty()) {
                prefix = prefix + ".";
            }
            for (Map.Entry entry : map.entrySet()) {
                this.assign(prefix + (String)entry.getKey(), entry.getValue());
            }
        } else {
            this.values.put(prefix, value == null ? null : value);
        }
    }

    public void unassign(String prefix) {
        Set<String> removed = this.values.keySet().stream().filter(s -> s.startsWith(prefix)).collect(Collectors.toSet());
        removed.forEach(this.values::remove);
    }

    public Object resolve(String var) {
        Object value = this.values.get(var);
        if (value != null) {
            return value;
        }
        if (!this.isGlobalScope()) {
            return this.parent.resolve(var);
        }
        return ObjectUtils.NULL;
    }

    public boolean isGlobalScope() {
        return this.parent == null;
    }

    public boolean hasSeen(String variable) {
        return this.variablesEncountered.contains(variable);
    }

    public void markAsSeen(String variable) {
        this.variablesEncountered.add(variable);
    }
}

