/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.template;

import ai.grakn.exception.GraqlSyntaxException;
import ai.grakn.graql.internal.antlr.GraqlTemplateBaseVisitor;
import ai.grakn.graql.internal.antlr.GraqlTemplateParser;
import ai.grakn.graql.internal.template.Scope;
import ai.grakn.graql.internal.template.macro.Unescaped;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.graql.macro.Macro;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang.ObjectUtils;

public class TemplateVisitor
extends GraqlTemplateBaseVisitor {
    private final CommonTokenStream tokens;
    private final Map<String, Object> originalContext;
    private final Map<String, Macro<?>> macros;
    private final Map<String, Integer> iteration = new HashMap<String, Integer>();
    private Scope scope;

    public TemplateVisitor(CommonTokenStream tokens, Map<String, Object> context, Map<String, Macro<?>> macros) {
        this.tokens = tokens;
        this.macros = macros;
        this.scope = new Scope(context);
        this.originalContext = context;
    }

    @Override
    public String visitTemplate(GraqlTemplateParser.TemplateContext ctx) {
        return this.visitBlockContents(ctx.blockContents());
    }

    @Override
    public String visitBlock(GraqlTemplateParser.BlockContext ctx) {
        return this.visitBlockContents(ctx.blockContents());
    }

    @Override
    public String visitBlockContents(GraqlTemplateParser.BlockContentsContext ctx) {
        this.scope = new Scope(this.scope);
        String returnValue = (String)this.visitChildren((RuleNode)ctx);
        this.scope = this.scope.up();
        return returnValue;
    }

    @Override
    public String visitForStatement(GraqlTemplateParser.ForStatementContext ctx) {
        String item = ctx.ID() != null ? ctx.ID().getText() : "";
        Object collection = this.visit((ParseTree)ctx.expr());
        if (!(collection instanceof List)) {
            return null;
        }
        Object returnValue = ObjectUtils.NULL;
        for (Object object : (List)collection) {
            this.scope.assign(item, object);
            returnValue = this.concat(returnValue, this.visit((ParseTree)ctx.block()));
            this.scope.unassign(item);
        }
        return returnValue == ObjectUtils.NULL ? "" : returnValue.toString();
    }

    @Override
    public String visitIfStatement(GraqlTemplateParser.IfStatementContext ctx) {
        if (((Boolean)this.visit((ParseTree)ctx.ifPartial().expr())).booleanValue()) {
            return (String)this.visit((ParseTree)ctx.ifPartial().block());
        }
        for (GraqlTemplateParser.ElseIfPartialContext elseIf : ctx.elseIfPartial()) {
            if (!((Boolean)this.visit((ParseTree)elseIf.expr())).booleanValue()) continue;
            return (String)this.visit((ParseTree)elseIf.block());
        }
        if (ctx.elsePartial() != null) {
            return (String)this.visit((ParseTree)ctx.elsePartial().block());
        }
        return "";
    }

    @Override
    public Object visitMacro(GraqlTemplateParser.MacroContext ctx) {
        String macro = ctx.ID_MACRO().getText().replace("@", "").toLowerCase();
        List values = ctx.expr().stream().map(arg_0 -> ((TemplateVisitor)this).visit(arg_0)).collect(Collectors.toList());
        return this.macros.get(macro).apply(values);
    }

    @Override
    public Object visitGroupExpression(GraqlTemplateParser.GroupExpressionContext ctx) {
        return this.visit((ParseTree)ctx.expr());
    }

    @Override
    public Boolean visitOrExpression(GraqlTemplateParser.OrExpressionContext ctx) {
        Object lValue = this.visit((ParseTree)ctx.expr(0));
        Object rValue = this.visit((ParseTree)ctx.expr(1));
        if (!(lValue instanceof Boolean) || !(rValue instanceof Boolean)) {
            throw GraqlSyntaxException.parsingTemplateError((String)"OR", (String)ctx.getText(), this.originalContext);
        }
        return (Boolean)lValue != false || (Boolean)rValue != false;
    }

    @Override
    public Boolean visitAndExpression(GraqlTemplateParser.AndExpressionContext ctx) {
        Object lValue = this.visit((ParseTree)ctx.expr(0));
        Object rValue = this.visit((ParseTree)ctx.expr(1));
        if (!(lValue instanceof Boolean) || !(rValue instanceof Boolean)) {
            throw GraqlSyntaxException.parsingTemplateError((String)"AND", (String)ctx.getText(), this.originalContext);
        }
        return (Boolean)lValue != false && (Boolean)rValue != false;
    }

    @Override
    public Boolean visitNotExpression(GraqlTemplateParser.NotExpressionContext ctx) {
        Object value = this.visit((ParseTree)ctx.expr());
        if (!(value instanceof Boolean)) {
            throw GraqlSyntaxException.parsingTemplateError((String)"NOT", (String)ctx.getText(), this.originalContext);
        }
        return (Boolean)value == false;
    }

    @Override
    public Boolean visitBooleanExpression(GraqlTemplateParser.BooleanExpressionContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public String visitStringExpression(GraqlTemplateParser.StringExpressionContext ctx) {
        return String.valueOf(ctx.getText().replaceAll("\"", ""));
    }

    @Override
    public Double visitDoubleExpression(GraqlTemplateParser.DoubleExpressionContext ctx) {
        return Double.valueOf(ctx.getText());
    }

    @Override
    public Integer visitIntExpression(GraqlTemplateParser.IntExpressionContext ctx) {
        return Integer.valueOf(ctx.getText());
    }

    @Override
    public Boolean visitEqExpression(GraqlTemplateParser.EqExpressionContext ctx) {
        Object lValue = this.visit((ParseTree)ctx.expr(0));
        Object rValue = this.visit((ParseTree)ctx.expr(1));
        return lValue.equals(rValue);
    }

    @Override
    public Boolean visitNotEqExpression(GraqlTemplateParser.NotEqExpressionContext ctx) {
        Object rValue;
        Object lValue = this.visit((ParseTree)ctx.expr(0));
        return !lValue.equals(rValue = this.visit((ParseTree)ctx.expr(1)));
    }

    @Override
    public Boolean visitGreaterExpression(GraqlTemplateParser.GreaterExpressionContext ctx) {
        Object lValue = this.visit((ParseTree)ctx.expr(0));
        Object rValue = this.visit((ParseTree)ctx.expr(1));
        if (!(lValue instanceof Number) || !(rValue instanceof Number)) {
            throw GraqlSyntaxException.parsingTemplateError((String)"GREATER THAN", (String)ctx.getText(), this.originalContext);
        }
        Number lNumber = (Number)lValue;
        Number rNumber = (Number)rValue;
        return lNumber.doubleValue() > rNumber.doubleValue();
    }

    @Override
    public Boolean visitGreaterEqExpression(GraqlTemplateParser.GreaterEqExpressionContext ctx) {
        Object lValue = this.visit((ParseTree)ctx.expr(0));
        Object rValue = this.visit((ParseTree)ctx.expr(1));
        if (!(lValue instanceof Number) || !(rValue instanceof Number)) {
            throw GraqlSyntaxException.parsingTemplateError((String)"GREATER THAN EQUALS", (String)ctx.getText(), this.originalContext);
        }
        Number lNumber = (Number)lValue;
        Number rNumber = (Number)rValue;
        return lNumber.doubleValue() >= rNumber.doubleValue();
    }

    @Override
    public Boolean visitLessExpression(GraqlTemplateParser.LessExpressionContext ctx) {
        Object lValue = this.visit((ParseTree)ctx.expr(0));
        Object rValue = this.visit((ParseTree)ctx.expr(1));
        if (!(lValue instanceof Number) || !(rValue instanceof Number)) {
            throw GraqlSyntaxException.parsingTemplateError((String)"LESS THAN", (String)ctx.getText(), this.originalContext);
        }
        Number lNumber = (Number)lValue;
        Number rNumber = (Number)rValue;
        return lNumber.doubleValue() < rNumber.doubleValue();
    }

    @Override
    public Boolean visitLessEqExpression(GraqlTemplateParser.LessEqExpressionContext ctx) {
        Object lValue = this.visit((ParseTree)ctx.expr(0));
        Object rValue = this.visit((ParseTree)ctx.expr(1));
        if (!(lValue instanceof Number) || !(rValue instanceof Number)) {
            throw GraqlSyntaxException.parsingTemplateError((String)"LESS THAN EQUALS", (String)ctx.getText(), this.originalContext);
        }
        Number lNumber = (Number)lValue;
        Number rNumber = (Number)rValue;
        return lNumber.doubleValue() <= rNumber.doubleValue();
    }

    @Override
    public Object visitNullExpression(GraqlTemplateParser.NullExpressionContext ctx) {
        return ObjectUtils.NULL;
    }

    @Override
    public Object visitResolveExpression(GraqlTemplateParser.ResolveExpressionContext ctx) {
        return this.visitResolve(ctx.resolve());
    }

    @Override
    public Object visitMacroExpression(GraqlTemplateParser.MacroExpressionContext ctx) {
        return this.visitMacro(ctx.macro());
    }

    @Override
    public String visitReplaceStatement(GraqlTemplateParser.ReplaceStatementContext ctx) {
        Object value = ObjectUtils.NULL;
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (ctx.macro(i) != null) {
                value = this.concat(value, this.visit((ParseTree)ctx.macro(i)));
            }
            if (ctx.resolve(i) == null) continue;
            value = this.concat(value, this.visit((ParseTree)ctx.resolve(i)));
        }
        if (value == ObjectUtils.NULL) {
            throw GraqlSyntaxException.parsingTemplateMissingKey((String)ctx.getText(), this.originalContext);
        }
        Function<Object, String> formatToApply = ctx.DOLLAR() != null ? this::formatVar : this::format;
        String prepend = ctx.DOLLAR() != null ? ctx.DOLLAR().getText() : "";
        return prepend + formatToApply.apply(value);
    }

    @Override
    public String visitGraqlVariable(GraqlTemplateParser.GraqlVariableContext ctx) {
        String var = ctx.getText();
        if (!this.scope.hasSeen(var)) {
            this.scope.markAsSeen(var);
            this.iteration.compute(var, (k, v) -> v == null ? 0 : v + 1);
        }
        return ctx.getText() + this.iteration.get(var);
    }

    public String visitTerminal(TerminalNode node) {
        int index = node.getSymbol().getTokenIndex();
        String lws = this.tokens.getHiddenTokensToLeft(index) != null ? this.tokens.getHiddenTokensToLeft(index).stream().map(Token::getText).collect(Collectors.joining()) : "";
        String rws = this.tokens.getHiddenTokensToRight(index) != null ? this.tokens.getHiddenTokensToRight(index).stream().map(Token::getText).collect(Collectors.joining()) : "";
        return lws + node.getText() + rws;
    }

    @Override
    public Object visitResolve(GraqlTemplateParser.ResolveContext ctx) {
        String key = ctx.ID() != null ? ctx.ID().getText() : ctx.STRING().getText().replaceAll("^\"|\"$", "");
        return this.scope.resolve(key);
    }

    private Object concat(Object ... values) {
        if (values.length == 1) {
            return values[0];
        }
        if (values.length == 2 && values[0] == ObjectUtils.NULL) {
            return values[1];
        }
        StringBuilder builder = new StringBuilder();
        for (Object value : values) {
            builder.append(value);
        }
        return builder.toString();
    }

    public String format(Object val) {
        if (val instanceof Unescaped) {
            return val.toString();
        }
        return StringConverter.valueToString(val);
    }

    private String formatVar(Object variable) {
        return variable.toString().replaceAll("[^a-zA-Z0-9]", "-");
    }

    protected Object aggregateResult(Object aggregate, Object nextResult) {
        if (aggregate == null) {
            return nextResult;
        }
        if (nextResult == null) {
            return aggregate;
        }
        return this.concat(aggregate, nextResult);
    }
}

