/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.template.macro;

import ai.grakn.graql.macro.Macro;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;

public class BooleanMacro
implements Macro<Boolean> {
    private static final Collection<String> allowedBooleanValues = ImmutableSet.of((Object)"true", (Object)"false");
    private static final int numberArguments = 1;

    public Boolean apply(List<Object> values) {
        if (values.size() != 1) {
            throw new IllegalArgumentException("Wrong number of arguments [" + values.size() + "] to macro " + this.name());
        }
        String booleanValue = values.get(0).toString().toLowerCase();
        if (!allowedBooleanValues.contains(booleanValue)) {
            throw new IllegalArgumentException("Wrong value for boolean in argument " + values + " to macro " + this.name());
        }
        return Boolean.parseBoolean(booleanValue);
    }

    public String name() {
        return "boolean";
    }
}

